/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.devtools.build.lib.util.LogHandlerQuerier;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class FileHandlerQuerier
extends LogHandlerQuerier {
    private final Supplier<LogManager> logManagerSupplier;

    @VisibleForTesting
    FileHandlerQuerier(Supplier<LogManager> logManagerSupplier) {
        this.logManagerSupplier = logManagerSupplier;
    }

    public FileHandlerQuerier() {
        this(() -> LogManager.getLogManager());
    }

    @Override
    protected boolean canQuery(Handler handler) {
        return handler instanceof FileHandler;
    }

    @Override
    protected Optional<Path> getLogHandlerFilePath(Handler handler) {
        String pattern = this.logManagerSupplier.get().getProperty("java.util.logging.FileHandler.pattern");
        if (pattern == null) {
            throw new IllegalStateException("java.util.logging.config property java.util.logging.FileHandler.pattern is undefined");
        }
        if (pattern.matches(".*%[thgu].*")) {
            throw new IllegalStateException("resolving %-coded variables in java.util.logging.config property java.util.logging.FileHandler.pattern is not supported");
        }
        Path path = Paths.get(pattern.trim(), new String[0]);
        if (!handler.isLoggable(new LogRecord(Level.SEVERE, ""))) {
            return Optional.empty();
        }
        return Optional.of(path);
    }
}

