/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util;

import com.google.common.base.Objects;
import com.google.errorprone.annotations.Immutable;
import java.util.Collection;
import java.util.HashMap;
import javax.annotation.Nullable;

@Immutable
public final class ExitCode {
    private static final HashMap<Integer, ExitCode> exitCodeRegistry = new HashMap();
    public static final ExitCode SUCCESS = ExitCode.create(0, "SUCCESS");
    public static final ExitCode BUILD_FAILURE = ExitCode.create(1, "BUILD_FAILURE");
    public static final ExitCode PARSING_FAILURE = ExitCode.createUnregistered(1, "PARSING_FAILURE");
    public static final ExitCode COMMAND_LINE_ERROR = ExitCode.create(2, "COMMAND_LINE_ERROR");
    public static final ExitCode TESTS_FAILED = ExitCode.create(3, "TESTS_FAILED");
    public static final ExitCode PARTIAL_ANALYSIS_FAILURE = ExitCode.createUnregistered(3, "PARTIAL_ANALYSIS_FAILURE");
    public static final ExitCode NO_TESTS_FOUND = ExitCode.create(4, "NO_TESTS_FOUND");
    public static final ExitCode RUN_FAILURE = ExitCode.create(6, "RUN_FAILURE");
    public static final ExitCode ANALYSIS_FAILURE = ExitCode.create(7, "ANALYSIS_FAILURE");
    public static final ExitCode INTERRUPTED = ExitCode.create(8, "INTERRUPTED");
    public static final ExitCode LOCK_HELD_NOBLOCK_FOR_LOCK = ExitCode.create(9, "LOCK_HELD_NOBLOCK_FOR_LOCK");
    public static final ExitCode REMOTE_ENVIRONMENTAL_ERROR = ExitCode.createInfrastructureFailure(32, "REMOTE_ENVIRONMENTAL_ERROR");
    public static final ExitCode OOM_ERROR = ExitCode.createInfrastructureFailure(33, "OOM_ERROR");
    public static final ExitCode REMOTE_ERROR = ExitCode.createInfrastructureFailure(34, "REMOTE_ERROR");
    public static final ExitCode LOCAL_ENVIRONMENTAL_ERROR = ExitCode.createInfrastructureFailure(36, "LOCAL_ENVIRONMENTAL_ERROR");
    public static final ExitCode BLAZE_INTERNAL_ERROR = ExitCode.createInfrastructureFailure(37, "BLAZE_INTERNAL_ERROR");
    public static final ExitCode TRANSIENT_BUILD_EVENT_SERVICE_UPLOAD_ERROR = ExitCode.createInfrastructureFailure(38, "PUBLISH_ERROR");
    public static final ExitCode REMOTE_CACHE_EVICTED = ExitCode.createInfrastructureFailure(39, "REMOTE_CACHE_EVICTED");
    public static final ExitCode PERSISTENT_BUILD_EVENT_SERVICE_UPLOAD_ERROR = ExitCode.create(45, "PERSISTENT_BUILD_EVENT_SERVICE_UPLOAD_ERROR");
    public static final ExitCode EXTERNAL_DEPS_ERROR = ExitCode.create(48, "EXTERNAL_DEPS_ERROR");
    private final int numericExitCode;
    private final String name;
    private final boolean infrastructureFailure;

    public static ExitCode create(int code, String name) {
        return new ExitCode(code, name, false, true);
    }

    public static ExitCode createInfrastructureFailure(int code, String name) {
        return new ExitCode(code, name, true, true);
    }

    private static ExitCode createUnregistered(int code, String name) {
        return new ExitCode(code, name, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void register(ExitCode exitCode) {
        HashMap<Integer, ExitCode> hashMap = exitCodeRegistry;
        synchronized (hashMap) {
            int codeNum = exitCode.getNumericExitCode();
            if (exitCodeRegistry.containsKey(codeNum)) {
                throw new IllegalStateException("Exit code " + codeNum + " (" + exitCode.name + ") already registered");
            }
            exitCodeRegistry.put(codeNum, exitCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<ExitCode> values() {
        HashMap<Integer, ExitCode> hashMap = exitCodeRegistry;
        synchronized (hashMap) {
            return exitCodeRegistry.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static ExitCode forCode(int code) {
        HashMap<Integer, ExitCode> hashMap = exitCodeRegistry;
        synchronized (hashMap) {
            return exitCodeRegistry.get(code);
        }
    }

    private ExitCode(int exitCode, String name, boolean infrastructureFailure, boolean register) {
        this.numericExitCode = exitCode;
        this.name = name;
        this.infrastructureFailure = infrastructureFailure;
        if (register) {
            ExitCode.register(this);
        }
    }

    public int hashCode() {
        return Objects.hashCode(this.numericExitCode, this.name, this.infrastructureFailure);
    }

    public boolean equals(Object object) {
        if (object instanceof ExitCode) {
            ExitCode that = (ExitCode)object;
            return this.numericExitCode == that.numericExitCode && this.name.equals(that.name) && this.infrastructureFailure == that.infrastructureFailure;
        }
        return false;
    }

    public String toString() {
        return this.name;
    }

    public int getNumericExitCode() {
        return this.numericExitCode;
    }

    public String name() {
        return this.name;
    }

    public boolean isInfrastructureFailure() {
        return this.infrastructureFailure;
    }
}

