/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class Either<A, B> {
    private Either() {
    }

    public static <A, B> Either<A, B> ofLeft(A a) {
        return new LeftEither(a);
    }

    public static <A, B> Either<A, B> ofRight(B b) {
        return new RightEither(b);
    }

    public abstract void consume(Consumer<A> var1, Consumer<B> var2);

    public abstract <C> C map(Function<A, C> var1, Function<B, C> var2);

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract String toString();

    private static class RightEither<A, B>
    extends Either<A, B> {
        private final B b;

        private RightEither(B b) {
            this.b = b;
        }

        @Override
        public void consume(Consumer<A> leftConsumer, Consumer<B> rightConsumer) {
            rightConsumer.accept(this.b);
        }

        @Override
        public <C> C map(Function<A, C> leftFunction, Function<B, C> rightFunction) {
            return rightFunction.apply(this.b);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.b);
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof RightEither)) {
                return false;
            }
            return Objects.equals(this.b, ((RightEither)other).b);
        }

        @Override
        public String toString() {
            return "right injection of " + this.b;
        }
    }

    private static class LeftEither<A, B>
    extends Either<A, B> {
        private final A a;

        private LeftEither(A a) {
            this.a = a;
        }

        @Override
        public void consume(Consumer<A> leftConsumer, Consumer<B> rightConsumer) {
            leftConsumer.accept(this.a);
        }

        @Override
        public <C> C map(Function<A, C> leftFunction, Function<B, C> rightFunction) {
            return leftFunction.apply(this.a);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.a);
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof LeftEither)) {
                return false;
            }
            return Objects.equals(this.a, ((LeftEither)other).a);
        }

        @Override
        public String toString() {
            return "left injection of " + this.a;
        }
    }
}

