/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util;

import com.google.common.base.Preconditions;
import com.google.devtools.build.lib.server.FailureDetails;
import com.google.devtools.build.lib.util.ExitCode;
import com.google.protobuf.Descriptors;
import com.google.protobuf.MessageOrBuilder;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class DetailedExitCode {
    private final ExitCode exitCode;
    @Nullable
    private final FailureDetails.FailureDetail failureDetail;

    private DetailedExitCode(ExitCode exitCode, @Nullable FailureDetails.FailureDetail failureDetail) {
        this.exitCode = exitCode;
        this.failureDetail = failureDetail;
    }

    public ExitCode getExitCode() {
        return this.exitCode;
    }

    public static ExitCode getExitCode(FailureDetails.FailureDetail failureDetail) {
        int numericExitCode = DetailedExitCode.getNumericExitCode(failureDetail);
        return Preconditions.checkNotNull(ExitCode.forCode(numericExitCode), "No ExitCode for numericExitCode %s", numericExitCode);
    }

    @Nullable
    public FailureDetails.FailureDetail getFailureDetail() {
        return this.failureDetail;
    }

    public boolean isSuccess() {
        return this.exitCode.equals(ExitCode.SUCCESS);
    }

    public static DetailedExitCode success() {
        return new DetailedExitCode(ExitCode.SUCCESS, null);
    }

    public static DetailedExitCode of(ExitCode exitCode, FailureDetails.FailureDetail failureDetail) {
        return new DetailedExitCode(Preconditions.checkNotNull(exitCode), Preconditions.checkNotNull(failureDetail));
    }

    public static DetailedExitCode of(FailureDetails.FailureDetail failureDetail) {
        return new DetailedExitCode(DetailedExitCode.getExitCode(failureDetail), Preconditions.checkNotNull(failureDetail));
    }

    public int hashCode() {
        return Objects.hash(this.exitCode, this.failureDetail);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DetailedExitCode)) {
            return false;
        }
        DetailedExitCode that = (DetailedExitCode)obj;
        return this.exitCode.equals(that.exitCode) && Objects.equals(this.failureDetail, that.failureDetail);
    }

    public String toString() {
        return String.format("DetailedExitCode{exitCode=%s, failureDetail=%s}", this.exitCode, this.failureDetail);
    }

    public static int getNumericExitCode(FailureDetails.FailureDetail failureDetail) {
        MessageOrBuilder categoryMsg = DetailedExitCode.getCategorySubmessage(failureDetail);
        Descriptors.EnumValueDescriptor subcategoryDescriptor = DetailedExitCode.getSubcategoryDescriptor(failureDetail, categoryMsg);
        return DetailedExitCode.getNumericExitCode(subcategoryDescriptor);
    }

    public static int getNumericExitCode(Descriptors.EnumValueDescriptor subcategoryDescriptor) {
        Preconditions.checkArgument(subcategoryDescriptor.getOptions().hasExtension(FailureDetails.metadata), "Enum value %s has no FailureDetails.metadata", (Object)subcategoryDescriptor);
        return subcategoryDescriptor.getOptions().getExtension(FailureDetails.metadata).getExitCode();
    }

    private static MessageOrBuilder getCategorySubmessage(FailureDetails.FailureDetail failureDetail) {
        MessageOrBuilder categoryMsg = null;
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : failureDetail.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor fieldDescriptor = entry.getKey();
            if (!DetailedExitCode.isCategoryField(fieldDescriptor)) continue;
            categoryMsg = (MessageOrBuilder)entry.getValue();
            break;
        }
        return Preconditions.checkNotNull(categoryMsg, "FailureDetail missing category submessage: %s", (Object)failureDetail);
    }

    private static boolean isCategoryField(Descriptors.FieldDescriptor fieldDescriptor) {
        int fieldNum = fieldDescriptor.getNumber();
        return 100 < fieldNum && fieldNum <= 10000;
    }

    private static Descriptors.EnumValueDescriptor getSubcategoryDescriptor(FailureDetails.FailureDetail failureDetail, MessageOrBuilder categoryMsg) {
        Descriptors.FieldDescriptor fieldNumberOne = categoryMsg.getDescriptorForType().findFieldByNumber(1);
        Preconditions.checkNotNull(fieldNumberOne, "FailureDetail category submessage has no field #1: %s", (Object)failureDetail);
        Object fieldNumberOneVal = categoryMsg.getField(fieldNumberOne);
        Preconditions.checkArgument(fieldNumberOneVal instanceof Descriptors.EnumValueDescriptor, "FailureDetail category submessage has non-enum field #1: %s", (Object)failureDetail);
        return (Descriptors.EnumValueDescriptor)fieldNumberOneVal;
    }

    public static class DetailedExitCodeComparator
    implements Comparator<DetailedExitCode> {
        public static final DetailedExitCodeComparator INSTANCE = new DetailedExitCodeComparator();

        private DetailedExitCodeComparator() {
        }

        @Nullable
        public static DetailedExitCode chooseMoreImportantWithFirstIfTie(@Nullable DetailedExitCode first, @Nullable DetailedExitCode second) {
            return INSTANCE.compare(first, second) >= 0 ? first : second;
        }

        @Override
        public int compare(DetailedExitCode c1, DetailedExitCode c2) {
            return DetailedExitCodeComparator.getPriority(c1) - DetailedExitCodeComparator.getPriority(c2);
        }

        private static int getPriority(DetailedExitCode code) {
            if (code == null) {
                return 0;
            }
            int codeClass = code.getExitCode().isInfrastructureFailure() ? 4 : 2;
            return codeClass + (code.getFailureDetail() != null ? 1 : 0);
        }
    }
}

