/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.devtools.build.lib.util.OS;
import com.google.devtools.build.lib.vfs.FileSystemUtils;
import com.google.devtools.build.lib.vfs.Path;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public final class DependencySet {
    private final Collection<Path> dependencies = new ArrayList<Path>();
    private final Path root;
    private String outputFileName;

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public void setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    public DependencySet(Path root) {
        this.root = root;
    }

    public Collection<Path> getDependencies() {
        return Collections.unmodifiableCollection(this.dependencies);
    }

    @VisibleForTesting
    public void addDependencies(Collection<Path> deps) {
        for (Path d : deps) {
            Preconditions.checkArgument(d.startsWith(this.root));
            this.dependencies.add(d);
        }
    }

    private void addDependency(String dep) {
        dep = this.translatePath(dep);
        Path depPath = this.root.getRelative(dep);
        this.dependencies.add(depPath);
    }

    private String translatePath(String path) {
        if (OS.getCurrent() != OS.WINDOWS) {
            return path;
        }
        return WindowsPath.translateWindowsPath(path);
    }

    public DependencySet read(Path dotdFile) throws IOException {
        byte[] content = FileSystemUtils.readContent(dotdFile);
        try {
            return this.process(content);
        }
        catch (IOException e) {
            throw new IOException("Error processing " + dotdFile + ": " + e.getMessage());
        }
    }

    @CanIgnoreReturnValue
    public DependencySet process(byte[] content) throws IOException {
        int n = content.length;
        if (n > 0 && content[n - 1] != 10) {
            throw new IOException("File does not end in a newline");
        }
        int w = 0;
        boolean sawTarget = false;
        int r = 0;
        block16: while (r < n) {
            byte c = content[r++];
            switch (c) {
                case 32: {
                    if (!sawTarget || w <= 0) continue block16;
                    this.addDependency(new String(content, 0, w, StandardCharsets.UTF_8));
                    w = 0;
                    continue block16;
                }
                case 13: {
                    continue block16;
                }
                case 10: {
                    if (sawTarget && w > 0) {
                        this.addDependency(new String(content, 0, w, StandardCharsets.UTF_8));
                    }
                    w = 0;
                    sawTarget = false;
                    continue block16;
                }
                case 58: {
                    switch (content[r]) {
                        case 10: 
                        case 13: 
                        case 32: {
                            if (w <= 0) continue block16;
                            this.outputFileName = new String(content, 0, w, StandardCharsets.UTF_8);
                            w = 0;
                            sawTarget = true;
                            continue block16;
                        }
                    }
                    content[w++] = c;
                    continue block16;
                }
                case 92: {
                    switch (content[r]) {
                        case 32: {
                            content[w++] = 32;
                            ++r;
                            continue block16;
                        }
                        case 10: {
                            ++r;
                            continue block16;
                        }
                        case 13: {
                            if (content[++r] != 10) continue block16;
                            ++r;
                            continue block16;
                        }
                    }
                    content[w++] = c;
                    continue block16;
                }
                case 36: {
                    if (content[r] != 36) break;
                    content[w++] = 36;
                    ++r;
                    continue block16;
                }
            }
            content[w++] = c;
        }
        return this;
    }

    public void write(Path outFile, String suffix) throws IOException {
        Path dotdFile = outFile.getRelative(FileSystemUtils.replaceExtension(outFile.asFragment(), suffix));
        try (PrintStream out = new PrintStream(dotdFile.getOutputStream());){
            out.print(outFile.relativeTo(this.root) + ": ");
            for (Path d : this.dependencies) {
                out.print(" \\\n  " + d.getPathString());
            }
            out.println();
        }
    }

    public boolean equals(Object other) {
        return other instanceof DependencySet && ((DependencySet)other).dependencies.equals(this.dependencies);
    }

    public int hashCode() {
        return this.dependencies.hashCode();
    }

    private static final class WindowsPath {
        private static final AtomicReference<String> UNIX_ROOT = new AtomicReference<Object>(null);

        private WindowsPath() {
        }

        private static String translateWindowsPath(String path) {
            int n = path.length();
            if (n == 0 || path.charAt(0) != '/') {
                return path;
            }
            if (n >= 2 && WindowsPath.isAsciiLetter(path.charAt(1)) && (n == 2 || path.charAt(2) == '/')) {
                StringBuilder sb = new StringBuilder(path.length());
                sb.append(Character.toUpperCase(path.charAt(1)));
                sb.append(":/");
                sb.append(path, 2, path.length());
                return sb.toString();
            }
            String unixRoot = WindowsPath.getUnixRoot();
            return unixRoot + path;
        }

        private static boolean isAsciiLetter(char c) {
            return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
        }

        private static String getUnixRoot() {
            String value = UNIX_ROOT.get();
            if (value == null) {
                String jvmFlag = "bazel.windows_unix_root";
                value = WindowsPath.determineUnixRoot(jvmFlag);
                if (value == null) {
                    throw new IllegalStateException(String.format("\"%1$s\" JVM flag is not set. Use the --host_jvm_args flag. For example: \"--host_jvm_args=-D%1$s=c:/tools/msys64\".", jvmFlag));
                }
                if ((value = value.replace('\\', '/')).length() > 3 && value.endsWith("/")) {
                    value = value.substring(0, value.length() - 1);
                }
                UNIX_ROOT.set(value);
            }
            return value;
        }

        @Nullable
        private static String determineUnixRoot(String jvmArgName) {
            String path = System.getProperty(jvmArgName);
            if (path == null) {
                return null;
            }
            if ((path = path.trim()).isEmpty()) {
                return null;
            }
            return path;
        }
    }
}

