/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.devtools.build.lib.server.FailureDetails;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;

public class CustomFailureDetailPublisher {
    @Nullable
    private static volatile Path failureDetailFilePath = null;

    private CustomFailureDetailPublisher() {
    }

    public static void setFailureDetailFilePath(String path) {
        failureDetailFilePath = Paths.get(path, new String[0]);
    }

    @VisibleForTesting
    public static void resetFailureDetailFilePath() {
        failureDetailFilePath = null;
    }

    public static boolean maybeWriteFailureDetailFile(FailureDetails.FailureDetail failureDetail) {
        Path path = failureDetailFilePath;
        if (path != null) {
            try {
                Files.write(path, failureDetail.toByteArray(), new OpenOption[0]);
                return true;
            }
            catch (IOException ioe) {
                System.err.printf("io error writing failure detail to file %s.\nfailure_detail: %s\nIOException: %s", path, failureDetail, ioe.getMessage());
            }
        }
        return false;
    }
}

