/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;

public class CustomExitCodePublisher {
    private static final String EXIT_CODE_FILENAME = "exit_code_to_use_on_abrupt_exit";
    @Nullable
    private static volatile Path abruptExitCodeFilePath = null;

    private CustomExitCodePublisher() {
    }

    public static void setAbruptExitStatusFileDir(String path) {
        abruptExitCodeFilePath = Paths.get(path, new String[0]).resolve(EXIT_CODE_FILENAME);
    }

    @VisibleForTesting
    public static void resetAbruptExitStatusFile() {
        abruptExitCodeFilePath = null;
    }

    public static boolean maybeWriteExitStatusFile(int exitCode) {
        Path path = abruptExitCodeFilePath;
        if (path != null) {
            try {
                Files.write(path, String.valueOf(exitCode).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                return true;
            }
            catch (IOException ioe) {
                System.err.printf("io error writing %d to abrupt exit status file %s: %s\n", exitCode, path, ioe.getMessage());
            }
        }
        return false;
    }
}

