/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util;

import com.google.common.base.Ascii;
import com.google.common.collect.Sets;
import com.google.common.flogger.GoogleLogger;
import com.google.devtools.build.lib.server.FailureDetails;
import com.google.devtools.build.lib.util.DetailedExitCode;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;

public class CrashFailureDetails {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final int MAX_THROWABLE_MESSAGE_LENGTH = 2000;
    private static final int MAX_CAUSE_CHAIN_SIZE = 5;
    private static final int MAX_STACK_TRACE_SIZE = 1000;
    private static BooleanSupplier oomDetector = () -> false;

    private CrashFailureDetails() {
    }

    public static void setOomDetector(BooleanSupplier oomDetector) {
        CrashFailureDetails.oomDetector = oomDetector;
    }

    public static boolean oomDetected() {
        return oomDetector.getAsBoolean();
    }

    public static DetailedExitCode detailedExitCodeForThrowable(Throwable throwable) {
        return DetailedExitCode.of(CrashFailureDetails.forThrowable(throwable));
    }

    public static FailureDetails.FailureDetail forThrowable(Throwable throwable) {
        FailureDetails.Crash.Builder crashBuilder = FailureDetails.Crash.newBuilder();
        if (CrashFailureDetails.getRootCauseToleratingCycles(throwable) instanceof OutOfMemoryError) {
            crashBuilder.setCode(FailureDetails.Crash.Code.CRASH_OOM);
        } else if (CrashFailureDetails.oomDetected()) {
            ((GoogleLogger.Api)logger.atWarning()).log("Classifying non-OOM crash as OOM");
            crashBuilder.setCode(FailureDetails.Crash.Code.CRASH_OOM).setOomDetectorOverride(true);
        } else {
            crashBuilder.setCode(FailureDetails.Crash.Code.CRASH_UNKNOWN);
        }
        CrashFailureDetails.addCause(crashBuilder, throwable, Sets.newIdentityHashSet());
        return FailureDetails.FailureDetail.newBuilder().setMessage("Crashed: " + CrashFailureDetails.joinSummarizedCauses(crashBuilder)).setCrash(crashBuilder).build();
    }

    private static String joinSummarizedCauses(FailureDetails.Crash.Builder crashBuilder) {
        return crashBuilder.getCausesOrBuilderList().stream().map(CrashFailureDetails::summarizeCause).collect(Collectors.joining(", "));
    }

    private static String summarizeCause(FailureDetails.ThrowableOrBuilder throwableOrBuilder) {
        return String.format("(%s) %s", throwableOrBuilder.getThrowableClass(), throwableOrBuilder.getMessage());
    }

    private static void addCause(FailureDetails.Crash.Builder crashBuilder, Throwable throwable, Set<Object> addedThrowables) {
        addedThrowables.add(throwable);
        crashBuilder.addCauses(CrashFailureDetails.getThrowable(throwable));
        Throwable cause = throwable.getCause();
        if (cause == null || addedThrowables.contains(cause) || crashBuilder.getCausesOrBuilderList().size() >= 5) {
            return;
        }
        CrashFailureDetails.addCause(crashBuilder, cause, addedThrowables);
    }

    private static FailureDetails.Throwable getThrowable(Throwable throwable) {
        StackTraceElement[] stackTrace;
        String throwableMessage = Ascii.truncate(throwable.getMessage() != null ? throwable.getMessage() : "", 2000, "[truncated]");
        FailureDetails.Throwable.Builder throwableBuilder = FailureDetails.Throwable.newBuilder().setMessage(throwableMessage).setThrowableClass(throwable.getClass().getName());
        for (StackTraceElement stackTraceElement : stackTrace = throwable.getStackTrace()) {
            if (throwableBuilder.getStackTraceList().size() >= 1000) break;
            throwableBuilder.addStackTrace(stackTraceElement.toString());
        }
        return throwableBuilder.build();
    }

    private static Throwable getRootCauseToleratingCycles(Throwable throwable) {
        Throwable cause;
        Throwable slowPointer = throwable;
        boolean advanceSlowPointer = false;
        while ((cause = throwable.getCause()) != null) {
            throwable = cause;
            if (throwable == slowPointer) {
                return throwable;
            }
            if (advanceSlowPointer) {
                slowPointer = slowPointer.getCause();
            }
            advanceSlowPointer = !advanceSlowPointer;
        }
        return throwable;
    }
}

