/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util;

import com.google.common.base.Preconditions;
import com.google.devtools.build.lib.util.AbstractIndexer;
import com.google.devtools.build.lib.util.StringCanonicalizer;
import java.util.Map;

public class CanonicalStringIndexer
extends AbstractIndexer {
    private static final int NOT_FOUND = -1;
    private final Map<String, Integer> stringToInt;
    private final Map<Integer, String> intToString;

    public CanonicalStringIndexer(Map<String, Integer> stringToInt, Map<Integer, String> intToString) {
        Preconditions.checkArgument(stringToInt.size() == intToString.size());
        this.stringToInt = stringToInt;
        this.intToString = intToString;
    }

    @Override
    public synchronized void clear() {
        this.stringToInt.clear();
        this.intToString.clear();
    }

    @Override
    public int size() {
        return this.intToString.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOrCreateIndex(String s2) {
        Integer i = this.stringToInt.get(s2);
        if (i == null) {
            s2 = StringCanonicalizer.intern(s2);
            CanonicalStringIndexer canonicalStringIndexer = this;
            synchronized (canonicalStringIndexer) {
                i = this.stringToInt.get(s2);
                if (i != null) {
                    return i;
                }
                int ind = this.intToString.size();
                this.stringToInt.put(s2, ind);
                this.intToString.put(ind, s2);
                return ind;
            }
        }
        return i;
    }

    @Override
    public int getIndex(String s2) {
        Integer i = this.stringToInt.get(s2);
        return i == null ? -1 : i;
    }

    @Override
    public synchronized boolean addString(String s2) {
        int originalSize = this.size();
        this.getOrCreateIndex(s2);
        return this.size() > originalSize;
    }

    @Override
    public String getStringForIndex(int i) {
        return this.intToString.get(i);
    }

    public synchronized String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("size = ").append(this.size()).append("\n");
        for (Map.Entry<String, Integer> entry : this.stringToInt.entrySet()) {
            builder.append(entry.getKey()).append(" <==> ").append(entry.getValue()).append("\n");
        }
        return builder.toString();
    }
}

