/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util;

import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableSet;

public enum CPU {
    X86_32("x86_32", ImmutableSet.of("i386", "i486", "i586", "i686", "i786", "x86", new String[0])),
    X86_64("x86_64", ImmutableSet.of("amd64", "x86_64", "x64")),
    PPC("ppc", ImmutableSet.of("ppc", "ppc64", "ppc64le")),
    ARM("arm", ImmutableSet.of("arm", "armv7l")),
    AARCH64("aarch64", ImmutableSet.of("aarch64")),
    S390X("s390x", ImmutableSet.of("s390x", "s390")),
    MIPS64("mips64", ImmutableSet.of("mips64el", "mips64")),
    RISCV64("riscv64", ImmutableSet.of("riscv64")),
    UNKNOWN("unknown", ImmutableSet.of());

    private final String canonicalName;
    private final ImmutableSet<String> archs;
    private static final CPU HOST_CPU;

    private CPU(String canonicalName, ImmutableSet<String> archs) {
        this.canonicalName = canonicalName;
        this.archs = archs;
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public static CPU getCurrent() {
        return HOST_CPU;
    }

    private static CPU determineCurrentCpu() {
        String currentArch = StandardSystemProperty.OS_ARCH.value();
        for (CPU cpu : CPU.values()) {
            if (!cpu.archs.contains(currentArch)) continue;
            return cpu;
        }
        return UNKNOWN;
    }

    static {
        HOST_CPU = CPU.determineCurrentCpu();
    }
}

