/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.util;

import java.io.IOException;
import java.io.OutputStream;

public class AnsiStrippingOutputStream
extends OutputStream {
    private byte[] outputBuffer;
    private int outputBufferPos;
    private static final int ESCAPE_BUFFER_LENGTH = 128;
    private byte[] escapeCodeBuffer;
    private int escapeCodeBufferPos;
    private OutputStream output;
    private State state;

    public AnsiStrippingOutputStream(OutputStream output) {
        this.output = output;
        this.escapeCodeBuffer = new byte[128];
        this.escapeCodeBufferPos = 0;
        this.state = State.NORMAL;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        byte[] array = new byte[]{(byte)(b & 0xFF)};
        this.write(array, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        int i;
        if (this.state == State.NORMAL) {
            for (i = 0; i < len && b[off + i] != 27; ++i) {
            }
            if (i == len) {
                this.output.write(b, off, len);
                return;
            }
        }
        this.outputBuffer = new byte[len + 128];
        System.arraycopy(b, off, this.outputBuffer, 0, i);
        this.outputBufferPos = i;
        while (i < len) {
            this.processByte(b[off + i]);
            ++i;
        }
        try {
            this.output.write(this.outputBuffer, 0, this.outputBufferPos);
        }
        finally {
            this.outputBuffer = null;
        }
    }

    private void processByte(byte b) {
        switch (this.state) {
            case NORMAL: {
                if (this.escapeCodeBufferPos != 0) {
                    throw new IllegalStateException();
                }
                if (b == 27) {
                    this.state = State.AFTER_ESCAPE;
                    this.addByteToEscapeBuffer(b);
                    break;
                }
                this.dumpByte(b);
                break;
            }
            case AFTER_ESCAPE: {
                if (b == 91) {
                    this.state = State.PARAMETER;
                    this.addByteToEscapeBuffer(b);
                    break;
                }
                if (b == 27) {
                    this.dumpEscapeBuffer();
                    this.state = State.AFTER_ESCAPE;
                    this.addByteToEscapeBuffer(b);
                    break;
                }
                this.dumpEscapeBuffer();
                this.dumpByte(b);
                this.state = State.NORMAL;
                break;
            }
            case PARAMETER: {
                if (b >= 48 && b <= 57 || b == 59) {
                    this.addByteToEscapeBuffer(b);
                    break;
                }
                if (b >= 97 && b <= 122 || b >= 65 && b <= 90) {
                    this.discardEscapeBuffer();
                    this.state = State.NORMAL;
                    break;
                }
                if (b == 27) {
                    this.dumpEscapeBuffer();
                    this.state = State.AFTER_ESCAPE;
                    this.addByteToEscapeBuffer(b);
                    break;
                }
                this.dumpEscapeBuffer();
                this.state = State.NORMAL;
            }
        }
    }

    private void addByteToEscapeBuffer(byte b) {
        this.escapeCodeBuffer[this.escapeCodeBufferPos++] = b;
        if (this.escapeCodeBufferPos == 128) {
            this.dumpEscapeBuffer();
            this.state = State.NORMAL;
        }
    }

    private void discardEscapeBuffer() {
        this.escapeCodeBufferPos = 0;
    }

    private void dumpByte(byte b) {
        this.outputBuffer[this.outputBufferPos++] = b;
    }

    private void dumpEscapeBuffer() {
        System.arraycopy(this.escapeCodeBuffer, 0, this.outputBuffer, this.outputBufferPos, this.escapeCodeBufferPos);
        this.outputBufferPos += this.escapeCodeBufferPos;
        this.escapeCodeBufferPos = 0;
    }

    @Override
    public void flush() throws IOException {
        this.output.flush();
    }

    @Override
    public void close() throws IOException {
        this.output.close();
    }

    private static enum State {
        NORMAL,
        AFTER_ESCAPE,
        PARAMETER;

    }
}

