/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.unsafe;

import com.google.devtools.build.lib.unsafe.UnsafeProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;

public final class StringUnsafe {
    public static final byte LATIN1 = 0;
    public static final byte UTF16 = 1;
    private static final StringUnsafe INSTANCE = new StringUnsafe();
    private final Constructor<String> constructor;
    private final long valueOffset;
    private final long coderOffset;

    public static StringUnsafe getInstance() {
        return INSTANCE;
    }

    private StringUnsafe() {
        Field coderField;
        Field valueField;
        try {
            this.constructor = String.class.getDeclaredConstructor(byte[].class, Byte.TYPE);
            valueField = String.class.getDeclaredField("value");
            coderField = String.class.getDeclaredField("coder");
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Bad fields/constructor: " + Arrays.toString(String.class.getDeclaredConstructors()) + ", " + Arrays.toString(String.class.getDeclaredFields()), e);
        }
        this.constructor.setAccessible(true);
        this.valueOffset = UnsafeProvider.unsafe().objectFieldOffset(valueField);
        this.coderOffset = UnsafeProvider.unsafe().objectFieldOffset(coderField);
    }

    public byte getCoder(String obj) {
        return UnsafeProvider.unsafe().getByte(obj, this.coderOffset);
    }

    public byte[] getByteArray(String obj) {
        return (byte[])UnsafeProvider.unsafe().getObject(obj, this.valueOffset);
    }

    public String newInstance(byte[] bytes, byte coder) throws ReflectiveOperationException {
        return this.constructor.newInstance(bytes, coder);
    }
}

