/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.unix;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProcMeminfoParser {
    public static final String FILE = "/proc/meminfo";
    private final Map<String, Long> memInfo;

    public ProcMeminfoParser() throws IOException {
        this(FILE);
    }

    @VisibleForTesting
    public ProcMeminfoParser(String fileName) throws IOException {
        List<String> lines = Files.readLines(new File(fileName), Charset.defaultCharset());
        HashMap<String, Long> newMemInfo = new HashMap<String, Long>();
        for (String line : lines) {
            int colon = line.indexOf(58);
            if (colon == -1) continue;
            String keyword = line.substring(0, colon);
            String valString = line.substring(colon + 1);
            try {
                long val = Long.parseLong(CharMatcher.inRange('0', '9').retainFrom(valString));
                newMemInfo.putIfAbsent(keyword, val);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.memInfo = ImmutableMap.copyOf(newMemInfo);
    }

    long getRamKb(String keyword) throws KeywordNotFoundException {
        Long val = this.memInfo.get(keyword);
        if (val == null) {
            throw new KeywordNotFoundException(keyword);
        }
        return val;
    }

    public long getTotalKb() throws KeywordNotFoundException {
        return this.getRamKb("MemTotal");
    }

    public static double kbToMb(long kb) {
        return kb >> 10;
    }

    public long getFreeRamKb() throws KeywordNotFoundException {
        if (this.memInfo.containsKey("MemAvailable")) {
            return this.getRamKb("MemAvailable");
        }
        return this.getRamKb("MemTotal") - this.getRamKb("Active") - (long)((double)this.getRamKb("Inactive") * 0.3) - (long)((double)this.getRamKb("Slab") * 0.8);
    }

    public static class KeywordNotFoundException
    extends IOException {
        private KeywordNotFoundException(String keyword) {
            super("Can't locate " + keyword + " in the /proc/meminfo");
        }
    }
}

