/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.supplier;

import com.google.common.base.Preconditions;
import com.google.devtools.build.lib.supplier.InterruptibleSupplier;
import javax.annotation.Nullable;

public interface MemoizingInterruptibleSupplier<T>
extends InterruptibleSupplier<T> {
    public boolean isInitialized();

    public static <T> MemoizingInterruptibleSupplier<T> of(InterruptibleSupplier<T> delegate) {
        if (delegate instanceof MemoizingInterruptibleSupplier) {
            return (MemoizingInterruptibleSupplier)delegate;
        }
        return new DelegatingMemoizingSupplier<T>(delegate);
    }

    public static final class DelegatingMemoizingSupplier<T>
    implements MemoizingInterruptibleSupplier<T> {
        @Nullable
        private InterruptibleSupplier<T> delegate;
        @Nullable
        private volatile T value = null;

        private DelegatingMemoizingSupplier(InterruptibleSupplier<T> delegate) {
            this.delegate = Preconditions.checkNotNull(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() throws InterruptedException {
            if (this.value != null) {
                return this.value;
            }
            DelegatingMemoizingSupplier delegatingMemoizingSupplier = this;
            synchronized (delegatingMemoizingSupplier) {
                if (this.value == null) {
                    this.value = this.delegate.get();
                    this.delegate = null;
                }
            }
            return this.value;
        }

        @Override
        public boolean isInitialized() {
            return this.value != null;
        }
    }
}

