/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.supplier;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.devtools.build.lib.supplier.InterruptibleSupplier;
import com.google.errorprone.annotations.ForOverride;
import java.lang.ref.SoftReference;
import javax.annotation.Nullable;

public abstract class EvictableSupplier<T>
implements InterruptibleSupplier<T> {
    private volatile SoftReference<T> valueReference;

    protected EvictableSupplier(@Nullable T cachedValue) {
        this.valueReference = new SoftReference<T>(cachedValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T get() throws InterruptedException {
        T value = this.valueReference.get();
        if (value != null) {
            return value;
        }
        EvictableSupplier evictableSupplier = this;
        synchronized (evictableSupplier) {
            value = this.valueReference.get();
            if (value != null) {
                return value;
            }
            value = Preconditions.checkNotNull(this.computeValue());
            this.valueReference = new SoftReference<T>(value);
            return value;
        }
    }

    @ForOverride
    protected abstract T computeValue() throws InterruptedException;

    @VisibleForTesting
    public final void evictForTesting() {
        this.valueReference.clear();
    }

    @Nullable
    protected final T peekCachedValue() {
        return this.valueReference.get();
    }
}

