/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.starlarkbuildapi.repository;

import com.google.devtools.build.docgen.annot.GlobalMethods;
import net.starlark.java.annot.Param;
import net.starlark.java.annot.ParamType;
import net.starlark.java.annot.StarlarkBuiltin;
import net.starlark.java.annot.StarlarkMethod;
import net.starlark.java.eval.Dict;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.NoneType;
import net.starlark.java.eval.Sequence;
import net.starlark.java.eval.StarlarkCallable;
import net.starlark.java.eval.StarlarkThread;
import net.starlark.java.eval.StarlarkValue;

@GlobalMethods(environment={GlobalMethods.Environment.BZL})
public interface RepositoryModuleApi {
    @StarlarkMethod(name="repository_rule", doc="Creates a new repository rule. Store it in a global value, so that it can be loaded and called from the WORKSPACE file.", parameters={@Param(name="implementation", named=true, doc="the function that implements this rule. Must have a single parameter, <code><a href=\"../builtins/repository_ctx.html\">repository_ctx</a></code>. The function is called during the loading phase for each instance of the rule."), @Param(name="attrs", allowedTypes={@ParamType(type=Dict.class), @ParamType(type=NoneType.class)}, defaultValue="None", doc="dictionary to declare all the attributes of the rule. It maps from an attribute name to an attribute object (see <a href=\"../toplevel/attr.html\">attr</a> module). Attributes starting with <code>_</code> are private, and can be used to add an implicit dependency on a label to a file (a repository rule cannot depend on a generated artifact). The attribute <code>name</code> is implicitly added and must not be specified.", named=true, positional=false), @Param(name="local", defaultValue="False", doc="Indicate that this rule fetches everything from the local system and should be reevaluated at every fetch.", named=true, positional=false), @Param(name="environ", allowedTypes={@ParamType(type=Sequence.class, generic1=String.class)}, defaultValue="[]", doc="Provides a list of environment variable that this repository rule depends on. If an environment variable in that list change, the repository will be refetched.", named=true, positional=false), @Param(name="configure", defaultValue="False", doc="Indicate that the repository inspects the system for configuration purpose", named=true, positional=false), @Param(name="remotable", defaultValue="False", doc="Compatible with remote execution", named=true, positional=false, enableOnlyWithFlag="-experimental_repo_remote_exec", valueWhenDisabled="False"), @Param(name="doc", defaultValue="''", doc="A description of the repository rule that can be extracted by documentation generating tools.", named=true, positional=false)}, useStarlarkThread=true)
    public StarlarkCallable repositoryRule(StarlarkCallable var1, Object var2, Boolean var3, Sequence<?> var4, Boolean var5, Boolean var6, String var7, StarlarkThread var8) throws EvalException;

    @StarlarkMethod(name="module_extension", doc="Creates a new module extension. Store it in a global value, so that it can be exported and used in a MODULE.bazel file.", parameters={@Param(name="implementation", named=true, doc="The function that implements this module extension. Must take a single parameter, <code><a href=\"../builtins/module_ctx.html\">module_ctx</a></code>. The function is called once at the beginning of a build to determine the set of available repos."), @Param(name="tag_classes", defaultValue="{}", doc="A dictionary to declare all the tag classes used by the extension. It maps from the name of the tag class to a <code><a href=\"../builtins/tag_class.html\">tag_class</a></code> object.", named=true, positional=false), @Param(name="doc", defaultValue="''", doc="A description of the module extension that can be extracted by documentation generating tools.", named=true, positional=false)}, useStarlarkThread=true)
    public Object moduleExtension(StarlarkCallable var1, Dict<?, ?> var2, String var3, StarlarkThread var4) throws EvalException;

    @StarlarkMethod(name="tag_class", doc="Creates a new tag_class object, which defines an attribute schema for a class of tags, which are data objects usable by a module extension.", parameters={@Param(name="attrs", defaultValue="{}", named=true, doc="A dictionary to declare all the attributes of this tag class. It maps from an attribute name to an attribute object (see <a href=\"../toplevel/attr.html\">attr</a> module)."), @Param(name="doc", defaultValue="''", doc="A description of the tag class that can be extracted by documentation generating tools.", named=true, positional=false)}, useStarlarkThread=true)
    public TagClassApi tagClass(Dict<?, ?> var1, String var2, StarlarkThread var3) throws EvalException;

    @StarlarkMethod(name="__do_not_use_fail_with_incompatible_use_cc_configure_from_rules_cc", doc="When --incompatible_use_cc_configure_from_rules_cc is set to true, Bazel will fail the build. Please see https://github.com/bazelbuild/bazel/issues/10134 for details and migration instructions.", documented=false, useStarlarkThread=true)
    public void failWithIncompatibleUseCcConfigureFromRulesCc(StarlarkThread var1) throws EvalException;

    @StarlarkBuiltin(name="tag_class", category="BUILTIN", doc="Defines a schema of attributes for a tag.")
    public static interface TagClassApi
    extends StarlarkValue {
    }
}

