/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.starlarkbuildapi.core;

import com.google.devtools.build.docgen.annot.StarlarkConstructor;
import com.google.devtools.build.lib.starlarkbuildapi.core.ProviderApi;
import net.starlark.java.annot.Param;
import net.starlark.java.annot.StarlarkBuiltin;
import net.starlark.java.annot.StarlarkMethod;
import net.starlark.java.eval.Dict;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.StarlarkThread;
import net.starlark.java.eval.StarlarkValue;

@StarlarkBuiltin(name="struct", category="BUILTIN", doc="A generic object with fields.<p>Structs fields cannot be reassigned once the struct is created. Two structs are equal if they have the same fields and if corresponding field values are equal.")
public interface StructApi
extends StarlarkValue {
    @StarlarkMethod(name="to_proto", doc="Creates a text message from the struct parameter. This method only works if all struct elements (recursively) are strings, ints, booleans, other structs or dicts or lists of these types. Quotes and new lines in strings are escaped. Struct keys are iterated in the sorted order. Examples:<br><pre class=language-python>struct(key=123).to_proto()\n# key: 123\n\nstruct(key=True).to_proto()\n# key: true\n\nstruct(key=[1, 2, 3]).to_proto()\n# key: 1\n# key: 2\n# key: 3\n\nstruct(key='text').to_proto()\n# key: \"text\"\n\nstruct(key=struct(inner_key='text')).to_proto()\n# key {\n#   inner_key: \"text\"\n# }\n\nstruct(key=[struct(inner_key=1), struct(inner_key=2)]).to_proto()\n# key {\n#   inner_key: 1\n# }\n# key {\n#   inner_key: 2\n# }\n\nstruct(key=struct(inner_key=struct(inner_inner_key='text'))).to_proto()\n# key {\n#    inner_key {\n#     inner_inner_key: \"text\"\n#   }\n# }\n\nstruct(foo={4: 3, 2: 1}).to_proto()\n# foo: {\n#   key: 4\n#   value: 3\n# }\n# foo: {\n#   key: 2\n#   value: 1\n# }\n</pre><p>Deprecated: use proto.encode_text(x) instead.", disableWithFlag="-incompatible_struct_has_no_methods")
    public String toProto() throws EvalException;

    @StarlarkMethod(name="to_json", doc="Creates a JSON string from the struct parameter. This method only works if all struct elements (recursively) are strings, ints, booleans, other structs, a list of these types or a dictionary with string keys and values of these types. Quotes and new lines in strings are escaped. Examples:<br><pre class=language-python>struct(key=123).to_json()\n# {\"key\":123}\n\nstruct(key=True).to_json()\n# {\"key\":true}\n\nstruct(key=[1, 2, 3]).to_json()\n# {\"key\":[1,2,3]}\n\nstruct(key='text').to_json()\n# {\"key\":\"text\"}\n\nstruct(key=struct(inner_key='text')).to_json()\n# {\"key\":{\"inner_key\":\"text\"}}\n\nstruct(key=[struct(inner_key=1), struct(inner_key=2)]).to_json()\n# {\"key\":[{\"inner_key\":1},{\"inner_key\":2}]}\n\nstruct(key=struct(inner_key=struct(inner_inner_key='text'))).to_json()\n# {\"key\":{\"inner_key\":{\"inner_inner_key\":\"text\"}}}\n</pre>.<p>Deprecated: instead, use json.encode(x) or json.encode_indent(x), which work for values other than structs and do not pollute the struct field namespace. ", disableWithFlag="-incompatible_struct_has_no_methods")
    public String toJson() throws EvalException;

    @StarlarkBuiltin(name="Provider", documented=false, doc="")
    public static interface StructProviderApi
    extends ProviderApi {
        @StarlarkMethod(name="struct", doc="Creates an immutable struct using the keyword arguments as attributes. It is used to group multiple values together. Example:<br><pre class=\"language-python\">s = struct(x = 2, y = 3)\nreturn s.x + getattr(s, \"y\")  # returns 5</pre>", extraKeywords=@Param(name="kwargs", defaultValue="{}", doc="Dictionary of arguments."), useStarlarkThread=true, selfCall=true)
        @StarlarkConstructor
        public StructApi createStruct(Dict<String, Object> var1, StarlarkThread var2) throws EvalException;
    }
}

