/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.starlarkbuildapi.core;

import com.google.common.collect.ImmutableSet;
import com.google.devtools.build.lib.cmdline.BazelCompileContext;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.cmdline.PackageIdentifier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.starlark.java.eval.GuardedValue;
import net.starlark.java.eval.StarlarkSemantics;

public final class ContextGuardedValue {
    private ContextGuardedValue() {
    }

    public static GuardedValue onlyInAllowedRepos(final Object obj, final ImmutableSet<PackageIdentifier> allowedPrefixes) {
        return new GuardedValue(){

            @Override
            public boolean isObjectAccessibleUsingSemantics(StarlarkSemantics semantics, @Nullable Object clientData) {
                if (clientData != null && clientData instanceof BazelCompileContext) {
                    BazelCompileContext context = (BazelCompileContext)clientData;
                    Label label = context.label();
                    for (PackageIdentifier prefix : allowedPrefixes) {
                        if (!label.getRepository().equals(prefix.getRepository()) || !label.getPackageFragment().startsWith(prefix.getPackageFragment())) continue;
                        return true;
                    }
                }
                return false;
            }

            @Override
            public String getErrorFromAttemptingAccess(String name) {
                return name + " may only be used from one of the following repositories or prefixes: " + allowedPrefixes.stream().map(PackageIdentifier::toString).collect(Collectors.joining(", "));
            }

            @Override
            public Object getObject() {
                return obj;
            }
        };
    }
}

