/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.starlarkbuildapi.core;

import com.google.common.collect.ImmutableSet;
import com.google.devtools.build.lib.cmdline.BazelCompileContext;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.cmdline.PackageIdentifier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.starlark.java.eval.FlagGuardedValue;
import net.starlark.java.eval.GuardedValue;
import net.starlark.java.eval.StarlarkSemantics;

public final class ContextAndFlagGuardedValue {
    public static GuardedValue onlyInAllowedReposOrWhenIncompatibleFlagIsFalse(final String flag, final Object obj, final ImmutableSet<PackageIdentifier> allowedPrefixes) {
        final GuardedValue flagGuard = FlagGuardedValue.onlyWhenIncompatibleFlagIsFalse(flag, obj);
        return new GuardedValue(){

            @Override
            public boolean isObjectAccessibleUsingSemantics(StarlarkSemantics semantics, @Nullable Object clientData) {
                boolean accessible = flagGuard.isObjectAccessibleUsingSemantics(semantics, clientData);
                if (!accessible && clientData != null && clientData instanceof BazelCompileContext) {
                    BazelCompileContext context = (BazelCompileContext)clientData;
                    Label label = context.label();
                    for (PackageIdentifier prefix : allowedPrefixes) {
                        if (!label.getRepository().equals(prefix.getRepository()) || !label.getPackageFragment().startsWith(prefix.getPackageFragment())) continue;
                        return true;
                    }
                }
                return accessible;
            }

            @Override
            public String getErrorFromAttemptingAccess(String name) {
                return name + " may only be used from one of the following repositories or prefixes: " + allowedPrefixes.stream().map(PackageIdentifier::toString).collect(Collectors.joining(", ")) + ". It may be temporarily re-enabled for general use by setting --" + flag.substring(1) + "=false";
            }

            @Override
            public Object getObject() {
                return obj;
            }
        };
    }

    private ContextAndFlagGuardedValue() {
    }
}

