/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.starlarkbuildapi;

import com.google.devtools.build.docgen.annot.GlobalMethods;
import net.starlark.java.annot.Param;
import net.starlark.java.annot.ParamType;
import net.starlark.java.annot.StarlarkMethod;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.NoneType;
import net.starlark.java.eval.Sequence;
import net.starlark.java.eval.StarlarkThread;

@GlobalMethods(environment={GlobalMethods.Environment.WORKSPACE})
public interface WorkspaceGlobalsApi {
    @StarlarkMethod(name="workspace", doc="<p>This function can only be used in a <code>WORKSPACE</code> file and must be declared before all other functions in the <code>WORKSPACE</code> file. Each <code>WORKSPACE</code> file should have a <code>workspace</code> function.</p><p>Sets the name for this workspace. Workspace names should be a Java-package-style description of the project, using underscores as separators, e.g., github.com/bazelbuild/bazel should use com_github_bazelbuild_bazel. <p>This name is used for the directory that the repository's runfiles are stored in. For example, if there is a runfile <code>foo/bar</code> in the local repository and the WORKSPACE file contains <code>workspace(name = 'baz')</code>, then the runfile will be available under <code>mytarget.runfiles/baz/foo/bar</code>.  If no workspace name is specified, then the runfile will be symlinked to <code>bar.runfiles/foo/bar</code>.</p> <p><a href=\"/docs/external\">Remote repository</a> rule names must be  valid workspace names. For example, you could have  <code>maven_jar(name = 'foo')</code>, but not  <code>maven_jar(name = 'foo%bar')</code>, as Bazel would attempt to write a  WORKSPACE file for the <code>maven_jar</code> containing  <code>workspace(name = 'foo%bar')</code>.</p>", parameters={@Param(name="name", doc="the name of the workspace. Names must start with a letter and can only contain letters, numbers, underscores, dashes, and dots.", named=true, positional=false)}, useStarlarkThread=true)
    public void workspace(String var1, StarlarkThread var2) throws EvalException, InterruptedException;

    @StarlarkMethod(name="register_execution_platforms", doc="Register an already-defined platform so that Bazel can use it as an <a href=\"${link toolchains#toolchain-resolution}\">execution platform</a> during <a href=\"${link toolchains}\">toolchain resolution</a>.", extraPositionals=@Param(name="platform_labels", allowedTypes={@ParamType(type=Sequence.class, generic1=String.class)}, doc="The labels of the platforms to register."), useStarlarkThread=true)
    public void registerExecutionPlatforms(Sequence<?> var1, StarlarkThread var2) throws EvalException, InterruptedException;

    @StarlarkMethod(name="register_toolchains", doc="Register an already-defined toolchain so that Bazel can use it during <a href=\"${link toolchains}\">toolchain resolution</a>. See examples of <a href=\"${link toolchains#defining-toolchains}\">defining</a> and <a href=\"${link toolchains#registering-and-building-with-toolchains}\">registering toolchains</a>.", extraPositionals=@Param(name="toolchain_labels", allowedTypes={@ParamType(type=Sequence.class, generic1=String.class)}, doc="The labels of the toolchains to register."), useStarlarkThread=true)
    public void registerToolchains(Sequence<?> var1, StarlarkThread var2) throws EvalException, InterruptedException;

    @StarlarkMethod(name="bind", doc="<p>Warning: use of <code>bind()</code> is not recommended. See <a href=\"https://github.com/bazelbuild/bazel/issues/1952\">Consider removing bind</a> for a long discussion of its issues and alternatives.</p> <p>Gives a target an alias in the <code>//external</code> package.</p>", parameters={@Param(name="name", named=true, positional=false, doc="The label under '//external' to serve as the alias name"), @Param(name="actual", allowedTypes={@ParamType(type=String.class), @ParamType(type=NoneType.class)}, named=true, positional=false, defaultValue="None", doc="The real label to be aliased")}, useStarlarkThread=true)
    public void bind(String var1, Object var2, StarlarkThread var3) throws EvalException, InterruptedException;
}

