/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.starlarkbuildapi;

import com.google.devtools.build.lib.starlarkbuildapi.core.StructApi;
import net.starlark.java.annot.StarlarkBuiltin;
import net.starlark.java.annot.StarlarkMethod;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.StarlarkValue;

@StarlarkBuiltin(name="rule_attributes", category="BUILTIN", doc="Information about attributes of a rule an aspect is applied to.")
public interface StarlarkAttributesCollectionApi
extends StarlarkValue {
    @StarlarkMethod(name="attr", structField=true, doc="A struct to access the values of the <a href='https://bazel.build/extending/rules#attributes'>attributes</a>. The values are provided by the user (if not, a default value is used). The attributes of the struct and the types of their values correspond to the keys and values of the <a href='../globals/bzl.html#rule.attrs'><code>attrs</code> dict</a> provided to the <a href='../globals/bzl.html#rule'><code>rule</code> function</a>. <a href=\"https://github.com/bazelbuild/examples/blob/main/rules/attributes/printer.bzl\">See example of use</a>.")
    public StructApi getAttr() throws EvalException;

    @StarlarkMethod(name="executable", structField=true, doc="A <code>struct</code> containing executable files defined in <a href='../toplevel/attr.html#label'>label type attributes</a> marked as <a href='../toplevel/attr.html#label.executable'><code>executable=True</code></a>. The struct fields correspond to the attribute names. Each value in the struct is either a <a href='../builtins/File.html'><code>File</code></a> or <code>None</code>. If an optional attribute is not specified in the rule then the corresponding struct value is <code>None</code>. If a label type is not marked as <code>executable=True</code>, no corresponding struct field is generated. <a href=\"https://github.com/bazelbuild/examples/blob/main/rules/actions_run/execute.bzl\">See example of use</a>.")
    public StructApi getExecutable() throws EvalException;

    @StarlarkMethod(name="file", structField=true, doc="A <code>struct</code> containing files defined in <a href='../toplevel/attr.html#label'>label type attributes</a> marked as <a href='../toplevel/attr.html#label.allow_single_file'><code>allow_single_file</code></a>. The struct fields correspond to the attribute names. The struct value is always a <a href='../builtins/File.html'><code>File</code></a> or <code>None</code>. If an optional attribute is not specified in the rule then the corresponding struct value is <code>None</code>. If a label type is not marked as <code>allow_single_file</code>, no corresponding struct field is generated. It is a shortcut for:<pre class=language-python>list(ctx.attr.&lt;ATTR&gt;.files)[0]</pre>In other words, use <code>file</code> to access the (singular) <a href=\"https://bazel.build/extending/rules#requesting_output_files\">default output</a> of a dependency. <a href=\"https://github.com/bazelbuild/examples/blob/main/rules/expand_template/hello.bzl\">See example of use</a>.")
    public StructApi getFile() throws EvalException;

    @StarlarkMethod(name="files", structField=true, doc="A <code>struct</code> containing files defined in <a href='../toplevel/attr.html#label'>label</a> or <a href='../toplevel/attr.html#label_list'>label list</a> type attributes. The struct fields correspond to the attribute names. The struct values are <code>list</code> of <a href='../builtins/File.html'><code>File</code></a>s.  It is a shortcut for:<pre class=language-python>[f for t in ctx.attr.&lt;ATTR&gt; for f in t.files]</pre> In other words, use <code>files</code> to access the <a href=\"https://bazel.build/extending/rules#requesting_output_files\"> default outputs</a> of a dependency. <a href=\"https://github.com/bazelbuild/examples/blob/main/rules/depsets/foo.bzl\">See example of use</a>.")
    public StructApi getFiles() throws EvalException;

    @StarlarkMethod(name="kind", structField=true, doc="The kind of a rule, such as 'cc_library'")
    public String getRuleClassName() throws EvalException;
}

