/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.starlarkbuildapi;

import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.starlarkbuildapi.LateBoundDefaultApi;
import com.google.devtools.build.lib.starlarkbuildapi.NativeComputedDefaultApi;
import com.google.devtools.build.lib.starlarkbuildapi.StarlarkAspectApi;
import net.starlark.java.annot.Param;
import net.starlark.java.annot.ParamType;
import net.starlark.java.annot.StarlarkBuiltin;
import net.starlark.java.annot.StarlarkMethod;
import net.starlark.java.eval.Dict;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.NoneType;
import net.starlark.java.eval.Sequence;
import net.starlark.java.eval.StarlarkFunction;
import net.starlark.java.eval.StarlarkInt;
import net.starlark.java.eval.StarlarkThread;
import net.starlark.java.eval.StarlarkValue;

@StarlarkBuiltin(name="attr", category="TOP_LEVEL_MODULE", doc="This is a top-level module for defining the attribute schemas of a rule or aspect. Each function returns an object representing the schema of a single attribute. These objects are used as the values of the <code>attrs</code> dictionary argument of <a href=\"../globals/bzl.html#rule\"><code>rule()</code></a> and <a href=\"../globals/bzl.html#aspect\"><code>aspect()</code></a>.<p>See the Rules page for more on <a href='https://bazel.build/extending/rules#attributes'>defining</a> and <a href='https://bazel.build/extending/rules#implementation_function'>using</a> attributes.")
public interface StarlarkAttrModuleApi
extends StarlarkValue {
    public static final String LABEL_PARAGRAPH = "<p>This attribute contains unique <a href='../builtins/Label.html'><code>Label</code></a> values. If a string is supplied in place of a <code>Label</code>, it will be converted using the <a href='../builtins/Label.html#Label'>label constructor</a>. The relative parts of the label path, including the (possibly renamed) repository, are resolved with respect to the instantiated target's package.";
    public static final String DEPENDENCY_ATTR_TEXT = "<p>This attribute contains unique <a href='../builtins/Label.html'><code>Label</code></a> values. If a string is supplied in place of a <code>Label</code>, it will be converted using the <a href='../builtins/Label.html#Label'>label constructor</a>. The relative parts of the label path, including the (possibly renamed) repository, are resolved with respect to the instantiated target's package.<p>At analysis time (within the rule's implementation function), when retrieving the attribute value from <code>ctx.attr</code>, labels are replaced by the corresponding <a href='../builtins/Target.html'><code>Target</code></a>s. This allows you to access the providers of the current target's dependencies.";
    public static final String OUTPUT_ATTR_TEXT = "<p>This attribute contains unique <a href='../builtins/Label.html'><code>Label</code></a> values. If a string is supplied in place of a <code>Label</code>, it will be converted using the <a href='../builtins/Label.html#Label'>label constructor</a>. The relative parts of the label path, including the (possibly renamed) repository, are resolved with respect to the instantiated target's package.<p>At analysis time, the corresponding <a href='../builtins/File.html'><code>File</code></a> can be retrieved using <a href='../builtins/ctx.html#outputs'><code>ctx.outputs</code></a>.";
    public static final String ALLOW_FILES_ARG = "allow_files";
    public static final String ALLOW_FILES_DOC = "Whether <code>File</code> targets are allowed. Can be <code>True</code>, <code>False</code> (default), or a list of file extensions that are allowed (for example, <code>[\".cc\", \".cpp\"]</code>).";
    public static final String ALLOW_RULES_ARG = "allow_rules";
    public static final String ALLOW_RULES_DOC = "Which rule targets (name of the classes) are allowed. This is deprecated (kept only for compatibility), use providers instead.";
    public static final String ASPECTS_ARG = "aspects";
    public static final String ASPECTS_ARG_DOC = "Aspects that should be applied to the dependency or dependencies specified by this attribute.";
    public static final String CONFIGURATION_ARG = "cfg";
    public static final String CONFIGURATION_DOC = "<a href=\"https://bazel.build/extending/rules#configurations\">Configuration</a> of the attribute. It can be either <code>\"exec\"</code>, which indicates that the dependency is built for the <code>execution platform</code>, or <code>\"target\"</code>, which indicates that the dependency is build for the <code>target platform</code>. A typical example of the difference is when building mobile apps, where the <code>target platform</code> is <code>Android</code> or <code>iOS</code> while the <code>execution platform</code> is <code>Linux</code>, <code>macOS</code>, or <code>Windows</code>.";
    public static final String DEFAULT_ARG = "default";
    public static final String DEFAULT_DOC = "A default value to use if no value for this attribute is given when instantiating the rule.";
    public static final String DOC_ARG = "doc";
    public static final String DOC_DOC = "A description of the attribute that can be extracted by documentation generating tools.";
    public static final String EXECUTABLE_ARG = "executable";
    public static final String EXECUTABLE_DOC = "True if the dependency has to be executable. This means the label must refer to an executable file, or to a rule that outputs an executable file. Access the label with <code>ctx.executable.&lt;attribute_name&gt;</code>.";
    public static final String FLAGS_ARG = "flags";
    public static final String FLAGS_DOC = "Deprecated, will be removed.";
    public static final String MANDATORY_ARG = "mandatory";
    public static final String MANDATORY_DOC = "If true, the value must be specified explicitly (even if it has a <code>default</code>).";
    public static final String ALLOW_EMPTY_ARG = "allow_empty";
    public static final String ALLOW_EMPTY_DOC = "True if the attribute can be empty.";
    public static final String PROVIDERS_ARG = "providers";
    public static final String PROVIDERS_DOC = "The providers that must be given by any dependency appearing in this attribute.<p>The format of this argument is a list of lists of providers -- <code>*Info</code> objects returned by <a href='../globals/bzl.html#provider'><code>provider()</code></a> (or in the case of a legacy provider, its string name). The dependency must return ALL providers mentioned in at least ONE of the inner lists. As a convenience, this argument may also be a single-level list of providers, in which case it is wrapped in an outer list with one element.It is NOT required that the rule of the dependency advertises those providers in its <code>provides<code> parameter, however, it is considered best practice.";
    public static final String ALLOW_SINGLE_FILE_ARG = "allow_single_file";
    public static final String VALUES_ARG = "values";
    public static final String VALUES_DOC = "The list of allowed values for the attribute. An error is raised if any other value is given.";

    @StarlarkMethod(name="int", doc="Creates a schema for an integer attribute. The value must be in the signed 32-bit range. The corresponding <a href='../builtins/ctx.html#attr'><code>ctx.attr</code></a> attribute will be of type <a href='../core/int.html'><code>int</code></a>.", parameters={@Param(name="default", defaultValue="0", doc="A default value to use if no value for this attribute is given when instantiating the rule.", named=true, positional=false), @Param(name="doc", allowedTypes={@ParamType(type=String.class), @ParamType(type=NoneType.class)}, defaultValue="None", doc="A description of the attribute that can be extracted by documentation generating tools.", named=true, positional=false), @Param(name="mandatory", defaultValue="False", doc="If true, the value must be specified explicitly (even if it has a <code>default</code>).", named=true, positional=false), @Param(name="values", allowedTypes={@ParamType(type=Sequence.class, generic1=StarlarkInt.class)}, defaultValue="[]", doc="The list of allowed values for the attribute. An error is raised if any other value is given.", named=true, positional=false)}, useStarlarkThread=true)
    public Descriptor intAttribute(StarlarkInt var1, Object var2, Boolean var3, Sequence<?> var4, StarlarkThread var5) throws EvalException;

    @StarlarkMethod(name="string", doc="Creates a schema for a <a href='../core/string.html#attr'>string</a> attribute.", parameters={@Param(name="default", defaultValue="''", doc="A default value to use if no value for this attribute is given when instantiating the rule.", allowedTypes={@ParamType(type=String.class), @ParamType(type=NativeComputedDefaultApi.class)}, named=true, positional=false), @Param(name="doc", allowedTypes={@ParamType(type=String.class), @ParamType(type=NoneType.class)}, defaultValue="None", doc="A description of the attribute that can be extracted by documentation generating tools.", named=true, positional=false), @Param(name="mandatory", defaultValue="False", doc="If true, the value must be specified explicitly (even if it has a <code>default</code>).", named=true, positional=false), @Param(name="values", allowedTypes={@ParamType(type=Sequence.class, generic1=String.class)}, defaultValue="[]", doc="The list of allowed values for the attribute. An error is raised if any other value is given.", named=true, positional=false)}, useStarlarkThread=true)
    public Descriptor stringAttribute(Object var1, Object var2, Boolean var3, Sequence<?> var4, StarlarkThread var5) throws EvalException;

    @StarlarkMethod(name="label", doc="<p>Creates a schema for a label attribute. This is a dependency attribute.</p><p>This attribute contains unique <a href='../builtins/Label.html'><code>Label</code></a> values. If a string is supplied in place of a <code>Label</code>, it will be converted using the <a href='../builtins/Label.html#Label'>label constructor</a>. The relative parts of the label path, including the (possibly renamed) repository, are resolved with respect to the instantiated target's package.<p>At analysis time (within the rule's implementation function), when retrieving the attribute value from <code>ctx.attr</code>, labels are replaced by the corresponding <a href='../builtins/Target.html'><code>Target</code></a>s. This allows you to access the providers of the current target's dependencies.<p>In addition to ordinary source files, this kind of attribute is often used to refer to a tool -- for example, a compiler. Such tools are considered to be dependencies, just like source files. To avoid requiring users to specify the tool's label every time they use the rule in their BUILD files, you can hard-code the label of a canonical tool as the <code>default</code> value of this attribute. If you also want to prevent users from overriding this default, you can make the attribute private by giving it a name that starts with an underscore. See the <a href='https://bazel.build/extending/rules#private-attributes'>Rules</a> page for more information.", parameters={@Param(name="default", allowedTypes={@ParamType(type=Label.class), @ParamType(type=String.class), @ParamType(type=LateBoundDefaultApi.class), @ParamType(type=NativeComputedDefaultApi.class), @ParamType(type=StarlarkFunction.class), @ParamType(type=NoneType.class)}, defaultValue="None", named=true, positional=false, doc="A default value to use if no value for this attribute is given when instantiating the rule.Use a string or the <a href=\"../builtins/Label.html#Label\"><code>Label</code></a> function to specify a default value, for example, <code>attr.label(default = \"//a:b\")</code>."), @Param(name="doc", allowedTypes={@ParamType(type=String.class), @ParamType(type=NoneType.class)}, defaultValue="None", doc="A description of the attribute that can be extracted by documentation generating tools.", named=true, positional=false), @Param(name="executable", defaultValue="False", named=true, positional=false, doc="True if the dependency has to be executable. This means the label must refer to an executable file, or to a rule that outputs an executable file. Access the label with <code>ctx.executable.&lt;attribute_name&gt;</code>."), @Param(name="allow_files", allowedTypes={@ParamType(type=Boolean.class), @ParamType(type=Sequence.class, generic1=String.class), @ParamType(type=NoneType.class)}, defaultValue="None", named=true, positional=false, doc="Whether <code>File</code> targets are allowed. Can be <code>True</code>, <code>False</code> (default), or a list of file extensions that are allowed (for example, <code>[\".cc\", \".cpp\"]</code>)."), @Param(name="allow_single_file", defaultValue="None", named=true, positional=false, doc="This is similar to <code>allow_files</code>, with the restriction that the label must correspond to a single <a href=\"../builtins/File.html\">File</a>. Access it through <code>ctx.file.&lt;attribute_name&gt;</code>."), @Param(name="mandatory", defaultValue="False", named=true, positional=false, doc="If true, the value must be specified explicitly (even if it has a <code>default</code>)."), @Param(name="providers", defaultValue="[]", named=true, positional=false, doc="The providers that must be given by any dependency appearing in this attribute.<p>The format of this argument is a list of lists of providers -- <code>*Info</code> objects returned by <a href='../globals/bzl.html#provider'><code>provider()</code></a> (or in the case of a legacy provider, its string name). The dependency must return ALL providers mentioned in at least ONE of the inner lists. As a convenience, this argument may also be a single-level list of providers, in which case it is wrapped in an outer list with one element.It is NOT required that the rule of the dependency advertises those providers in its <code>provides<code> parameter, however, it is considered best practice."), @Param(name="allow_rules", allowedTypes={@ParamType(type=Sequence.class, generic1=String.class), @ParamType(type=NoneType.class)}, defaultValue="None", named=true, positional=false, doc="Which rule targets (name of the classes) are allowed. This is deprecated (kept only for compatibility), use providers instead."), @Param(name="cfg", defaultValue="None", named=true, positional=false, doc="<a href=\"https://bazel.build/extending/rules#configurations\">Configuration</a> of the attribute. It can be either <code>\"exec\"</code>, which indicates that the dependency is built for the <code>execution platform</code>, or <code>\"target\"</code>, which indicates that the dependency is build for the <code>target platform</code>. A typical example of the difference is when building mobile apps, where the <code>target platform</code> is <code>Android</code> or <code>iOS</code> while the <code>execution platform</code> is <code>Linux</code>, <code>macOS</code>, or <code>Windows</code>. This parameter is required if <code>executable</code> is True to guard against accidentally building host tools in the target configuration. <code>\"target\"</code> has no semantic effect, so don't set it when <code>executable</code> is False unless it really helps clarify your intentions."), @Param(name="aspects", allowedTypes={@ParamType(type=Sequence.class, generic1=StarlarkAspectApi.class)}, defaultValue="[]", named=true, positional=false, doc="Aspects that should be applied to the dependency or dependencies specified by this attribute."), @Param(name="flags", defaultValue="unbound", allowedTypes={@ParamType(type=Sequence.class, generic1=String.class)}, named=true, positional=false, documented=false, doc="Deprecated, will be removed.")}, useStarlarkThread=true)
    public Descriptor labelAttribute(Object var1, Object var2, Boolean var3, Object var4, Object var5, Boolean var6, Sequence<?> var7, Object var8, Object var9, Sequence<?> var10, Object var11, StarlarkThread var12) throws EvalException;

    @StarlarkMethod(name="string_list", doc="Creates a schema for a list-of-strings attribute.", parameters={@Param(name="mandatory", defaultValue="False", doc="If true, the value must be specified explicitly (even if it has a <code>default</code>).", named=true), @Param(name="allow_empty", defaultValue="True", doc="True if the attribute can be empty.", named=true), @Param(name="default", allowedTypes={@ParamType(type=Sequence.class, generic1=String.class), @ParamType(type=NativeComputedDefaultApi.class)}, defaultValue="[]", doc="A default value to use if no value for this attribute is given when instantiating the rule.", named=true, positional=false), @Param(name="doc", allowedTypes={@ParamType(type=String.class), @ParamType(type=NoneType.class)}, defaultValue="None", doc="A description of the attribute that can be extracted by documentation generating tools.", named=true, positional=false)}, useStarlarkThread=true)
    public Descriptor stringListAttribute(Boolean var1, Boolean var2, Object var3, Object var4, StarlarkThread var5) throws EvalException;

    @StarlarkMethod(name="int_list", doc="Creates a schema for a list-of-integers attribute. Each element must be in the signed 32-bit range.", parameters={@Param(name="mandatory", defaultValue="False", doc="If true, the value must be specified explicitly (even if it has a <code>default</code>).", named=true), @Param(name="allow_empty", defaultValue="True", doc="True if the attribute can be empty.", named=true), @Param(name="default", allowedTypes={@ParamType(type=Sequence.class, generic1=StarlarkInt.class)}, defaultValue="[]", doc="A default value to use if no value for this attribute is given when instantiating the rule.", named=true, positional=false), @Param(name="doc", allowedTypes={@ParamType(type=String.class), @ParamType(type=NoneType.class)}, defaultValue="None", doc="A description of the attribute that can be extracted by documentation generating tools.", named=true, positional=false)}, useStarlarkThread=true)
    public Descriptor intListAttribute(Boolean var1, Boolean var2, Sequence<?> var3, Object var4, StarlarkThread var5) throws EvalException;

    @StarlarkMethod(name="label_list", doc="<p>Creates a schema for a list-of-labels attribute. This is a dependency attribute. The corresponding <a href='../builtins/ctx.html#attr'><code>ctx.attr</code></a> attribute will be of type <a href='../core/list.html'>list</a> of <a href='../builtins/Target.html'><code>Target</code>s</a>.</p><p>This attribute contains unique <a href='../builtins/Label.html'><code>Label</code></a> values. If a string is supplied in place of a <code>Label</code>, it will be converted using the <a href='../builtins/Label.html#Label'>label constructor</a>. The relative parts of the label path, including the (possibly renamed) repository, are resolved with respect to the instantiated target's package.<p>At analysis time (within the rule's implementation function), when retrieving the attribute value from <code>ctx.attr</code>, labels are replaced by the corresponding <a href='../builtins/Target.html'><code>Target</code></a>s. This allows you to access the providers of the current target's dependencies.", parameters={@Param(name="allow_empty", defaultValue="True", doc="True if the attribute can be empty.", named=true), @Param(name="default", allowedTypes={@ParamType(type=Sequence.class, generic1=Label.class), @ParamType(type=StarlarkFunction.class)}, defaultValue="[]", named=true, positional=false, doc="A default value to use if no value for this attribute is given when instantiating the rule.Use strings or the <a href=\"../builtins/Label.html#Label\"><code>Label</code></a> function to specify default values, for example, <code>attr.label_list(default = [\"//a:b\", \"//a:c\"])</code>."), @Param(name="doc", allowedTypes={@ParamType(type=String.class), @ParamType(type=NoneType.class)}, defaultValue="None", doc="A description of the attribute that can be extracted by documentation generating tools.", named=true, positional=false), @Param(name="allow_files", allowedTypes={@ParamType(type=Boolean.class), @ParamType(type=Sequence.class, generic1=String.class), @ParamType(type=NoneType.class)}, defaultValue="None", named=true, positional=false, doc="Whether <code>File</code> targets are allowed. Can be <code>True</code>, <code>False</code> (default), or a list of file extensions that are allowed (for example, <code>[\".cc\", \".cpp\"]</code>)."), @Param(name="allow_rules", allowedTypes={@ParamType(type=Sequence.class, generic1=String.class), @ParamType(type=NoneType.class)}, defaultValue="None", named=true, positional=false, doc="Which rule targets (name of the classes) are allowed. This is deprecated (kept only for compatibility), use providers instead."), @Param(name="providers", defaultValue="[]", named=true, positional=false, doc="The providers that must be given by any dependency appearing in this attribute.<p>The format of this argument is a list of lists of providers -- <code>*Info</code> objects returned by <a href='../globals/bzl.html#provider'><code>provider()</code></a> (or in the case of a legacy provider, its string name). The dependency must return ALL providers mentioned in at least ONE of the inner lists. As a convenience, this argument may also be a single-level list of providers, in which case it is wrapped in an outer list with one element.It is NOT required that the rule of the dependency advertises those providers in its <code>provides<code> parameter, however, it is considered best practice."), @Param(name="flags", allowedTypes={@ParamType(type=Sequence.class, generic1=String.class)}, defaultValue="[]", named=true, positional=false, doc="Deprecated, will be removed."), @Param(name="mandatory", defaultValue="False", named=true, positional=false, doc="If true, the value must be specified explicitly (even if it has a <code>default</code>)."), @Param(name="cfg", defaultValue="None", named=true, positional=false, doc="<a href=\"https://bazel.build/extending/rules#configurations\">Configuration</a> of the attribute. It can be either <code>\"exec\"</code>, which indicates that the dependency is built for the <code>execution platform</code>, or <code>\"target\"</code>, which indicates that the dependency is build for the <code>target platform</code>. A typical example of the difference is when building mobile apps, where the <code>target platform</code> is <code>Android</code> or <code>iOS</code> while the <code>execution platform</code> is <code>Linux</code>, <code>macOS</code>, or <code>Windows</code>."), @Param(name="aspects", allowedTypes={@ParamType(type=Sequence.class, generic1=StarlarkAspectApi.class)}, defaultValue="[]", named=true, positional=false, doc="Aspects that should be applied to the dependency or dependencies specified by this attribute.")}, useStarlarkThread=true)
    public Descriptor labelListAttribute(Boolean var1, Object var2, Object var3, Object var4, Object var5, Sequence<?> var6, Sequence<?> var7, Boolean var8, Object var9, Sequence<?> var10, StarlarkThread var11) throws EvalException;

    @StarlarkMethod(name="label_keyed_string_dict", doc="<p>Creates a schema for an attribute holding a dictionary, where the keys are labels and the values are strings. This is a dependency attribute.</p><p>This attribute contains unique <a href='../builtins/Label.html'><code>Label</code></a> values. If a string is supplied in place of a <code>Label</code>, it will be converted using the <a href='../builtins/Label.html#Label'>label constructor</a>. The relative parts of the label path, including the (possibly renamed) repository, are resolved with respect to the instantiated target's package.<p>At analysis time (within the rule's implementation function), when retrieving the attribute value from <code>ctx.attr</code>, labels are replaced by the corresponding <a href='../builtins/Target.html'><code>Target</code></a>s. This allows you to access the providers of the current target's dependencies.", parameters={@Param(name="allow_empty", defaultValue="True", doc="True if the attribute can be empty.", named=true), @Param(name="default", allowedTypes={@ParamType(type=Dict.class), @ParamType(type=StarlarkFunction.class)}, defaultValue="{}", named=true, positional=false, doc="A default value to use if no value for this attribute is given when instantiating the rule.Use strings or the <a href=\"../builtins/Label.html#Label\"><code>Label</code></a> function to specify default values, for example, <code>attr.label_keyed_string_dict(default = {\"//a:b\": \"value\", \"//a:c\": \"string\"})</code>."), @Param(name="doc", allowedTypes={@ParamType(type=String.class), @ParamType(type=NoneType.class)}, defaultValue="None", doc="A description of the attribute that can be extracted by documentation generating tools.", named=true, positional=false), @Param(name="allow_files", allowedTypes={@ParamType(type=Boolean.class), @ParamType(type=Sequence.class, generic1=String.class), @ParamType(type=NoneType.class)}, defaultValue="None", named=true, positional=false, doc="Whether <code>File</code> targets are allowed. Can be <code>True</code>, <code>False</code> (default), or a list of file extensions that are allowed (for example, <code>[\".cc\", \".cpp\"]</code>)."), @Param(name="allow_rules", allowedTypes={@ParamType(type=Sequence.class, generic1=String.class), @ParamType(type=NoneType.class)}, defaultValue="None", named=true, positional=false, doc="Which rule targets (name of the classes) are allowed. This is deprecated (kept only for compatibility), use providers instead."), @Param(name="providers", defaultValue="[]", named=true, positional=false, doc="The providers that must be given by any dependency appearing in this attribute.<p>The format of this argument is a list of lists of providers -- <code>*Info</code> objects returned by <a href='../globals/bzl.html#provider'><code>provider()</code></a> (or in the case of a legacy provider, its string name). The dependency must return ALL providers mentioned in at least ONE of the inner lists. As a convenience, this argument may also be a single-level list of providers, in which case it is wrapped in an outer list with one element.It is NOT required that the rule of the dependency advertises those providers in its <code>provides<code> parameter, however, it is considered best practice."), @Param(name="flags", allowedTypes={@ParamType(type=Sequence.class, generic1=String.class)}, defaultValue="[]", named=true, positional=false, doc="Deprecated, will be removed."), @Param(name="mandatory", defaultValue="False", named=true, positional=false, doc="If true, the value must be specified explicitly (even if it has a <code>default</code>)."), @Param(name="cfg", defaultValue="None", named=true, positional=false, doc="<a href=\"https://bazel.build/extending/rules#configurations\">Configuration</a> of the attribute. It can be either <code>\"exec\"</code>, which indicates that the dependency is built for the <code>execution platform</code>, or <code>\"target\"</code>, which indicates that the dependency is build for the <code>target platform</code>. A typical example of the difference is when building mobile apps, where the <code>target platform</code> is <code>Android</code> or <code>iOS</code> while the <code>execution platform</code> is <code>Linux</code>, <code>macOS</code>, or <code>Windows</code>."), @Param(name="aspects", allowedTypes={@ParamType(type=Sequence.class, generic1=StarlarkAspectApi.class)}, defaultValue="[]", named=true, positional=false, doc="Aspects that should be applied to the dependency or dependencies specified by this attribute.")}, useStarlarkThread=true)
    public Descriptor labelKeyedStringDictAttribute(Boolean var1, Object var2, Object var3, Object var4, Object var5, Sequence<?> var6, Sequence<?> var7, Boolean var8, Object var9, Sequence<?> var10, StarlarkThread var11) throws EvalException;

    @StarlarkMethod(name="bool", doc="Creates a schema for a boolean attribute. The corresponding <a href='../builtins/ctx.html#attr'><code>ctx.attr</code></a> attribute will be of type <a href='../core/bool.html'><code>bool</code></a>.", parameters={@Param(name="default", defaultValue="False", named=true, positional=false, doc="A default value to use if no value for this attribute is given when instantiating the rule."), @Param(name="doc", allowedTypes={@ParamType(type=String.class), @ParamType(type=NoneType.class)}, defaultValue="None", doc="A description of the attribute that can be extracted by documentation generating tools.", named=true, positional=false), @Param(name="mandatory", defaultValue="False", named=true, positional=false, doc="If true, the value must be specified explicitly (even if it has a <code>default</code>).")}, useStarlarkThread=true)
    public Descriptor boolAttribute(Boolean var1, Object var2, Boolean var3, StarlarkThread var4) throws EvalException;

    @StarlarkMethod(name="output", doc="<p>Creates a schema for an output (label) attribute.</p><p>This attribute contains unique <a href='../builtins/Label.html'><code>Label</code></a> values. If a string is supplied in place of a <code>Label</code>, it will be converted using the <a href='../builtins/Label.html#Label'>label constructor</a>. The relative parts of the label path, including the (possibly renamed) repository, are resolved with respect to the instantiated target's package.<p>At analysis time, the corresponding <a href='../builtins/File.html'><code>File</code></a> can be retrieved using <a href='../builtins/ctx.html#outputs'><code>ctx.outputs</code></a>.", parameters={@Param(name="doc", allowedTypes={@ParamType(type=String.class), @ParamType(type=NoneType.class)}, defaultValue="None", doc="A description of the attribute that can be extracted by documentation generating tools.", named=true, positional=false), @Param(name="mandatory", defaultValue="False", named=true, positional=false, doc="If true, the value must be specified explicitly (even if it has a <code>default</code>).")}, useStarlarkThread=true)
    public Descriptor outputAttribute(Object var1, Boolean var2, StarlarkThread var3) throws EvalException;

    @StarlarkMethod(name="output_list", doc="Creates a schema for a list-of-outputs attribute.<p>This attribute contains unique <a href='../builtins/Label.html'><code>Label</code></a> values. If a string is supplied in place of a <code>Label</code>, it will be converted using the <a href='../builtins/Label.html#Label'>label constructor</a>. The relative parts of the label path, including the (possibly renamed) repository, are resolved with respect to the instantiated target's package.<p>At analysis time, the corresponding <a href='../builtins/File.html'><code>File</code></a> can be retrieved using <a href='../builtins/ctx.html#outputs'><code>ctx.outputs</code></a>.", parameters={@Param(name="allow_empty", defaultValue="True", doc="True if the attribute can be empty.", named=true), @Param(name="doc", allowedTypes={@ParamType(type=String.class), @ParamType(type=NoneType.class)}, defaultValue="None", doc="A description of the attribute that can be extracted by documentation generating tools.", named=true, positional=false), @Param(name="mandatory", defaultValue="False", named=true, positional=false, doc="If true, the value must be specified explicitly (even if it has a <code>default</code>).")}, useStarlarkThread=true)
    public Descriptor outputListAttribute(Boolean var1, Object var2, Boolean var3, StarlarkThread var4) throws EvalException;

    @StarlarkMethod(name="string_dict", doc="Creates a schema for an attribute holding a dictionary, where the keys and values are strings.", parameters={@Param(name="allow_empty", defaultValue="True", doc="True if the attribute can be empty.", named=true), @Param(name="default", named=true, positional=false, defaultValue="{}", doc="A default value to use if no value for this attribute is given when instantiating the rule."), @Param(name="doc", allowedTypes={@ParamType(type=String.class), @ParamType(type=NoneType.class)}, defaultValue="None", doc="A description of the attribute that can be extracted by documentation generating tools.", named=true, positional=false), @Param(name="mandatory", named=true, positional=false, defaultValue="False", doc="If true, the value must be specified explicitly (even if it has a <code>default</code>).")}, useStarlarkThread=true)
    public Descriptor stringDictAttribute(Boolean var1, Dict<?, ?> var2, Object var3, Boolean var4, StarlarkThread var5) throws EvalException;

    @StarlarkMethod(name="string_list_dict", doc="Creates a schema for an attribute holding a dictionary, where the keys are strings and the values are lists of strings.", parameters={@Param(name="allow_empty", defaultValue="True", doc="True if the attribute can be empty.", named=true), @Param(name="default", defaultValue="{}", named=true, positional=false, doc="A default value to use if no value for this attribute is given when instantiating the rule."), @Param(name="doc", allowedTypes={@ParamType(type=String.class), @ParamType(type=NoneType.class)}, defaultValue="None", doc="A description of the attribute that can be extracted by documentation generating tools.", named=true, positional=false), @Param(name="mandatory", defaultValue="False", named=true, positional=false, doc="If true, the value must be specified explicitly (even if it has a <code>default</code>).")}, useStarlarkThread=true)
    public Descriptor stringListDictAttribute(Boolean var1, Dict<?, ?> var2, Object var3, Boolean var4, StarlarkThread var5) throws EvalException;

    @StarlarkMethod(name="license", doc="Creates a schema for a license attribute.", parameters={@Param(name="default", defaultValue="None", named=true, positional=false, doc="A default value to use if no value for this attribute is given when instantiating the rule."), @Param(name="doc", allowedTypes={@ParamType(type=String.class), @ParamType(type=NoneType.class)}, defaultValue="None", doc="A description of the attribute that can be extracted by documentation generating tools.", named=true, positional=false), @Param(name="mandatory", defaultValue="False", named=true, positional=false, doc="If true, the value must be specified explicitly (even if it has a <code>default</code>).")}, disableWithFlag="+incompatible_no_attr_license", useStarlarkThread=true)
    public Descriptor licenseAttribute(Object var1, Object var2, Boolean var3, StarlarkThread var4) throws EvalException;

    @StarlarkBuiltin(name="Attribute", category="BUILTIN", doc="Representation of a definition of an attribute. Use the <a href=\"../toplevel/attr.html\">attr</a> module to create an Attribute. They are only for use with a <a href=\"../globals/bzl.html#rule\">rule</a> or an <a href=\"../globals/bzl.html#aspect\">aspect</a>.")
    public static interface Descriptor
    extends StarlarkValue {
    }
}

