/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.starlarkbuildapi;

import com.google.devtools.build.lib.collect.nestedset.Depset;
import net.starlark.java.annot.Param;
import net.starlark.java.annot.ParamType;
import net.starlark.java.annot.StarlarkBuiltin;
import net.starlark.java.annot.StarlarkMethod;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Sequence;
import net.starlark.java.eval.StarlarkThread;
import net.starlark.java.eval.StarlarkValue;

@StarlarkBuiltin(name="runfiles", category="BUILTIN", doc="A container of information regarding a set of files required at runtime execution. This object should be passed via <a href=\"../providers/DefaultInfo.html\">DefaultInfo</a> in order to tell the build system about the runfiles needed by the outputs produced by the rule. <p>See <a href=\"https://bazel.build/extending/rules#runfiles\">runfiles guide</a> for details.")
public interface RunfilesApi
extends StarlarkValue {
    @StarlarkMethod(name="files", doc="Returns the set of runfiles as files.", structField=true)
    public Depset getArtifactsForStarlark();

    @StarlarkMethod(name="symlinks", doc="Returns the set of symlinks.", structField=true)
    public Depset getSymlinksForStarlark();

    @StarlarkMethod(name="root_symlinks", doc="Returns the set of root symlinks.", structField=true)
    public Depset getRootSymlinksForStarlark();

    @StarlarkMethod(name="empty_filenames", doc="Returns names of empty files to create.", structField=true)
    public Depset getEmptyFilenamesForStarlark();

    @StarlarkMethod(name="merge", doc="Returns a new runfiles object that includes all the contents of this one and the argument.<p><i>Note:</i> When you have many runfiles objects to merge, use <a href='#merge_all'><code>merge_all()</code></a> rather than calling <code>merge</code> in a loop. This avoids constructing deep depset structures which can cause build failures.", parameters={@Param(name="other", positional=true, named=false, doc="The runfiles object to merge into this.")}, useStarlarkThread=true)
    public RunfilesApi merge(RunfilesApi var1, StarlarkThread var2) throws EvalException;

    @StarlarkMethod(name="merge_all", doc="Returns a new runfiles object that includes all the contents of this one and of the runfiles objects in the argument.", parameters={@Param(name="other", allowedTypes={@ParamType(type=Sequence.class, generic1=RunfilesApi.class)}, positional=true, named=false, doc="The sequence of runfiles objects to merge into this.")}, useStarlarkThread=true)
    public RunfilesApi mergeAll(Sequence<?> var1, StarlarkThread var2) throws EvalException;
}

