/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.starlarkbuildapi;

import com.google.devtools.build.docgen.annot.StarlarkConstructor;
import com.google.devtools.build.lib.collect.nestedset.Depset;
import com.google.devtools.build.lib.starlarkbuildapi.FileApi;
import com.google.devtools.build.lib.starlarkbuildapi.FilesToRunProviderApi;
import com.google.devtools.build.lib.starlarkbuildapi.RunfilesApi;
import com.google.devtools.build.lib.starlarkbuildapi.core.ProviderApi;
import com.google.devtools.build.lib.starlarkbuildapi.core.StructApi;
import javax.annotation.Nullable;
import net.starlark.java.annot.Param;
import net.starlark.java.annot.ParamType;
import net.starlark.java.annot.StarlarkBuiltin;
import net.starlark.java.annot.StarlarkMethod;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.NoneType;
import net.starlark.java.eval.StarlarkThread;

@StarlarkBuiltin(name="DefaultInfo", category="PROVIDER", doc="A provider that gives general information about a target's direct and transitive files. Every rule type has this provider, even if it is not returned explicitly by the rule's implementation function. Each <code>DefaultInfo</code> instance has the following fields: <ul><li><code>files</code><li><code>files_to_run</code><li><code>data_runfiles</code><li><code>default_runfiles</code></ul>See the <a href='https://bazel.build/extending/rules'>rules</a> page for extensive guides on how to use this provider.")
public interface DefaultInfoApi
extends StructApi {
    public static final String DEPRECATED_RUNFILES_PARAMETER_WARNING = "<p><b>It is recommended that you avoid using this parameter (see <a href='https://bazel.build/extending/rules#runfiles_features_to_avoid'>\"runfiles features to avoid\"</a>)</b></p> ";

    @StarlarkMethod(name="files", doc="A <a href='../builtins/depset.html'><code>depset</code></a> of <a href='../builtins/File.html'><code>File</code></a> objects representing the default outputs to build when this target is specified on the bazel command line. By default it is all predeclared outputs.", structField=true, allowReturnNones=true)
    @Nullable
    public Depset getFiles();

    @StarlarkMethod(name="files_to_run", doc="A <a href='../providers/FilesToRunProvider.html'><code>FilesToRunProvider</code></a> object containing information about the executable and runfiles of the target.", structField=true, allowReturnNones=true)
    @Nullable
    public FilesToRunProviderApi<?> getFilesToRun();

    @StarlarkMethod(name="data_runfiles", doc="runfiles descriptor describing the files that this target needs when run in the condition that it is a <code>data</code> dependency attribute. Under most circumstances, use the <code>default_runfiles</code> parameter instead. See <a href='https://bazel.build/extending/rules#runfiles_features_to_avoid'>\"runfiles features to avoid\"</a> for details. ", structField=true, allowReturnNones=true)
    @Nullable
    public RunfilesApi getDataRunfiles();

    @StarlarkMethod(name="default_runfiles", doc="runfiles descriptor describing the files that this target needs when run (via the <code>run</code> command or as a tool dependency).", structField=true, allowReturnNones=true)
    @Nullable
    public RunfilesApi getDefaultRunfiles();

    @StarlarkBuiltin(name="Provider", documented=false, doc="")
    public static interface DefaultInfoApiProvider<RunfilesT extends RunfilesApi, FileT extends FileApi>
    extends ProviderApi {
        @StarlarkMethod(name="DefaultInfo", doc="<p>The <code>DefaultInfo</code> constructor.", parameters={@Param(name="files", allowedTypes={@ParamType(type=Depset.class), @ParamType(type=NoneType.class)}, named=true, positional=false, defaultValue="None", doc="A <a href='../builtins/depset.html'><code>depset</code></a> of <a href='../builtins/File.html'><code>File</code></a> objects representing the default outputs to build when this target is specified on the bazel command line. By default it is all predeclared outputs."), @Param(name="runfiles", allowedTypes={@ParamType(type=RunfilesApi.class), @ParamType(type=NoneType.class)}, named=true, positional=false, defaultValue="None", doc="runfiles descriptor describing the files that this target needs when run (via the <code>run</code> command or as a tool dependency)."), @Param(name="data_runfiles", allowedTypes={@ParamType(type=RunfilesApi.class), @ParamType(type=NoneType.class)}, named=true, positional=false, defaultValue="None", doc="<p><b>It is recommended that you avoid using this parameter (see <a href='https://bazel.build/extending/rules#runfiles_features_to_avoid'>\"runfiles features to avoid\"</a>)</b></p> runfiles descriptor describing the runfiles this target needs to run when it is a dependency via the <code>data</code> attribute."), @Param(name="default_runfiles", allowedTypes={@ParamType(type=RunfilesApi.class), @ParamType(type=NoneType.class)}, named=true, positional=false, defaultValue="None", doc="<p><b>It is recommended that you avoid using this parameter (see <a href='https://bazel.build/extending/rules#runfiles_features_to_avoid'>\"runfiles features to avoid\"</a>)</b></p> runfiles descriptor describing the runfiles this target needs to run when it is a dependency via any attribute other than the <code>data</code> attribute."), @Param(name="executable", allowedTypes={@ParamType(type=FileApi.class), @ParamType(type=NoneType.class)}, named=true, positional=false, defaultValue="None", doc="If this rule is marked <a href='../globals/bzl.html#rule.executable'><code>executable</code></a> or <a href='../globals/bzl.html#rule.test'><code>test</code></a>, this is a <a href='../builtins/File.html'><code>File</code></a> object representing the file that should be executed to run the target. By default it is the predeclared output <code>ctx.outputs.executable</code>.")}, selfCall=true, useStarlarkThread=true)
        @StarlarkConstructor
        public DefaultInfoApi constructor(Object var1, Object var2, Object var3, Object var4, Object var5, StarlarkThread var6) throws EvalException;
    }
}

