/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.starlarkbuildapi;

import com.google.common.collect.ImmutableMap;
import com.google.devtools.build.lib.starlarkbuildapi.FileRootApi;
import net.starlark.java.annot.StarlarkBuiltin;
import net.starlark.java.annot.StarlarkMethod;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.StarlarkThread;
import net.starlark.java.eval.StarlarkValue;

@StarlarkBuiltin(name="configuration", category="BUILTIN", doc="This object holds information about the environment in which the build is running. See the <a href='https://bazel.build/extending/rules#configurations'>Rules page</a> for more on the general concept of configurations.")
public interface BuildConfigurationApi
extends StarlarkValue {
    @StarlarkMethod(name="bin_dir", structField=true, documented=false)
    @Deprecated
    public FileRootApi getBinDir();

    @StarlarkMethod(name="genfiles_dir", structField=true, documented=false)
    @Deprecated
    public FileRootApi getGenfilesDir();

    @StarlarkMethod(name="host_path_separator", structField=true, doc="Returns the separator for PATH environment variable, which is ':' on Unix.")
    public String getHostPathSeparator();

    @StarlarkMethod(name="default_shell_env", structField=true, doc="A dictionary representing the static local shell environment. It maps variables to their values (strings).")
    @Deprecated
    public ImmutableMap<String, String> getLocalShellEnvironment();

    @StarlarkMethod(name="test_env", structField=true, doc="A dictionary containing user-specified test environment variables and their values, as set by the --test_env options. DO NOT USE! This is not the complete environment!")
    public ImmutableMap<String, String> getTestEnv();

    @StarlarkMethod(name="coverage_enabled", structField=true, doc="A boolean that tells whether code coverage is enabled for this run. Note that this does not compute whether a specific rule should be instrumented for code coverage data collection. For that, see the <a href=\"../builtins/ctx.html#coverage_instrumented\"><code>ctx.coverage_instrumented</code></a> function.")
    public boolean isCodeCoverageEnabled();

    @StarlarkMethod(name="stamp_binaries", documented=false, useStarlarkThread=true)
    public boolean stampBinariesForStarlark(StarlarkThread var1) throws EvalException;

    @StarlarkMethod(name="is_tool_configuration", documented=false, useStarlarkThread=true)
    public boolean isToolConfigurationForStarlark(StarlarkThread var1) throws EvalException;

    @StarlarkMethod(name="has_separate_genfiles_directory", documented=false, useStarlarkThread=true)
    public boolean hasSeparateGenfilesDirectoryForStarlark(StarlarkThread var1) throws EvalException;

    @StarlarkMethod(name="is_sibling_repository_layout", documented=false, useStarlarkThread=true)
    public boolean isSiblingRepositoryLayoutForStarlark(StarlarkThread var1) throws EvalException;

    @StarlarkMethod(name="runfiles_enabled", documented=false, useStarlarkThread=true)
    public boolean runfilesEnabledForStarlark(StarlarkThread var1) throws EvalException;
}

