/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.devtools.build.lib.skyframe.serialization.AutoRegistry;
import com.google.devtools.build.lib.skyframe.serialization.Memoizer;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodecRegistry;
import com.google.devtools.build.lib.skyframe.serialization.SerializationDependencyProvider;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class SerializationContext
implements SerializationDependencyProvider {
    private final ObjectCodecRegistry registry;
    private final ImmutableClassToInstanceMap<Object> dependencies;
    @Nullable
    private final Memoizer.Serializer serializer;
    private final Set<Class<?>> explicitlyAllowedClasses;
    @Nullable
    private List<ListenableFuture<Void>> futuresToBlockWritingOn;
    private final boolean allowFuturesToBlockWritingOn;

    private SerializationContext(ObjectCodecRegistry registry, ImmutableClassToInstanceMap<Object> dependencies, @Nullable Memoizer.Serializer serializer, boolean allowFuturesToBlockWritingOn) {
        this.registry = registry;
        this.dependencies = dependencies;
        this.serializer = serializer;
        this.allowFuturesToBlockWritingOn = allowFuturesToBlockWritingOn;
        this.explicitlyAllowedClasses = serializer != null ? new HashSet() : ImmutableSet.of();
    }

    @VisibleForTesting
    public SerializationContext(ObjectCodecRegistry registry, ImmutableClassToInstanceMap<Object> dependencies) {
        this(registry, dependencies, null, false);
    }

    @VisibleForTesting
    public SerializationContext(ImmutableClassToInstanceMap<Object> dependencies) {
        this(AutoRegistry.get(), dependencies);
    }

    public void serialize(Object object, CodedOutputStream codedOut) throws IOException, SerializationException {
        this.serializeInternal(object, null, codedOut);
    }

    void serializeWithAdHocMemoizationStrategy(Object object, ObjectCodec.MemoizationStrategy memoizationStrategy, CodedOutputStream codedOut) throws IOException, SerializationException {
        this.serializeInternal(object, memoizationStrategy, codedOut);
    }

    private void serializeInternal(Object object, @Nullable ObjectCodec.MemoizationStrategy customMemoizationStrategy, CodedOutputStream codedOut) throws IOException, SerializationException {
        ObjectCodecRegistry.CodecDescriptor descriptor = this.recordAndGetDescriptorIfNotConstantMemoizedOrNull(object, codedOut);
        if (descriptor != null) {
            if (this.serializer == null) {
                descriptor.serialize(this, object, codedOut);
            } else {
                ObjectCodec<?> castCodec = descriptor.getCodec();
                ObjectCodec.MemoizationStrategy memoizationStrategy = customMemoizationStrategy != null ? customMemoizationStrategy : castCodec.getStrategy();
                this.serializer.serialize(this, object, castCodec, codedOut, memoizationStrategy);
            }
        }
    }

    @Override
    public <T> T getDependency(Class<T> type) {
        return Preconditions.checkNotNull(this.dependencies.getInstance(type), "Missing dependency of type %s", type);
    }

    @CheckReturnValue
    public SerializationContext getMemoizingContext() {
        if (this.serializer != null) {
            return this;
        }
        return this.getNewMemoizingContext(false);
    }

    @CheckReturnValue
    public SerializationContext getMemoizingAndBlockingOnWriteContext() {
        Preconditions.checkState(this.serializer == null, "Should only be called on base serializationContext");
        Preconditions.checkState(!this.allowFuturesToBlockWritingOn, "Should only be called on base serializationContext");
        return this.getNewMemoizingContext(true);
    }

    public SerializationContext getNewMemoizingContext() {
        return this.getNewMemoizingContext(this.allowFuturesToBlockWritingOn);
    }

    private SerializationContext getNewMemoizingContext(boolean allowFuturesToBlockWritingOn) {
        return new SerializationContext(this.registry, this.dependencies, new Memoizer.Serializer(), allowFuturesToBlockWritingOn);
    }

    @CheckReturnValue
    public SerializationContext withDependencyOverrides(ClassToInstanceMap<?> dependencyOverrides) {
        Preconditions.checkState(this.serializer == null, "Must only be called on base SerializationContext");
        return new SerializationContext(this.registry, ImmutableClassToInstanceMap.builder().putAll(Maps.filterKeys(this.dependencies, k -> !dependencyOverrides.containsKey(k))).putAll(dependencyOverrides).build(), null, this.allowFuturesToBlockWritingOn);
    }

    public void addFutureToBlockWritingOn(ListenableFuture<Void> future) {
        Preconditions.checkState(this.allowFuturesToBlockWritingOn, "This context cannot block on a future");
        if (this.futuresToBlockWritingOn == null) {
            this.futuresToBlockWritingOn = new ArrayList<ListenableFuture<Void>>();
        }
        this.futuresToBlockWritingOn.add(future);
    }

    @Nullable
    public ListenableFuture<Void> createFutureToBlockWritingOn() {
        return this.futuresToBlockWritingOn != null ? Futures.whenAllSucceed(this.futuresToBlockWritingOn).call(() -> null, MoreExecutors.directExecutor()) : null;
    }

    public <T> void checkClassExplicitlyAllowed(Class<T> allowedClass, T objectForDebugging) throws SerializationException {
        if (this.serializer == null) {
            throw new SerializationException("Cannot check explicitly allowed class " + allowedClass + " without memoization (" + objectForDebugging + ")");
        }
        if (!this.explicitlyAllowedClasses.contains(allowedClass)) {
            throw new SerializationException(allowedClass + " not explicitly allowed (allowed classes were: " + this.explicitlyAllowedClasses + ") and object is " + objectForDebugging);
        }
    }

    public void addExplicitlyAllowedClass(Class<?> allowedClass) throws SerializationException {
        if (this.serializer == null) {
            throw new SerializationException("Cannot add explicitly allowed class %s without memoization: " + allowedClass);
        }
        this.explicitlyAllowedClasses.add(allowedClass);
    }

    private boolean writeNullOrConstant(@Nullable Object object, CodedOutputStream codedOut) throws IOException {
        if (object == null) {
            codedOut.writeSInt32NoTag(0);
            return true;
        }
        Integer tag = this.registry.maybeGetTagForConstant(object);
        if (tag != null) {
            codedOut.writeSInt32NoTag(tag);
            return true;
        }
        return false;
    }

    @Nullable
    private ObjectCodecRegistry.CodecDescriptor recordAndGetDescriptorIfNotConstantMemoizedOrNull(@Nullable Object object, CodedOutputStream codedOut) throws IOException, SerializationException.NoCodecException {
        Integer memoizedIndex;
        if (this.writeNullOrConstant(object, codedOut)) {
            return null;
        }
        if (this.serializer != null && (memoizedIndex = this.serializer.getMemoizedIndex(object)) != null) {
            codedOut.writeSInt32NoTag(-memoizedIndex.intValue() - 1);
            return null;
        }
        ObjectCodecRegistry.CodecDescriptor descriptor = this.registry.getCodecDescriptorForObject(object);
        codedOut.writeSInt32NoTag(descriptor.getTag());
        return descriptor;
    }
}

