/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class MultimapCodec<K, V>
implements ObjectCodec<Multimap<K, V>> {
    @Override
    public Class<? extends ImmutableMultimap<K, V>> getEncodedClass() {
        return ImmutableMultimap.class;
    }

    @Override
    public List<Class<? extends Multimap<K, V>>> additionalEncodedClasses() {
        return ImmutableList.of(LinkedHashMultimap.class);
    }

    @Override
    public void serialize(SerializationContext context, Multimap<K, V> obj, CodedOutputStream codedOut) throws SerializationException, IOException {
        if (obj instanceof ListMultimap) {
            codedOut.writeBoolNoTag(true);
        } else if (obj instanceof SetMultimap) {
            codedOut.writeBoolNoTag(false);
        } else {
            throw new SerializationException("Unexpected multimap type: " + obj.getClass());
        }
        codedOut.writeInt32NoTag(obj.asMap().size());
        for (Map.Entry<K, Collection<V>> entry : obj.asMap().entrySet()) {
            context.serialize(entry.getKey(), codedOut);
            context.serialize(entry.getValue(), codedOut);
        }
    }

    @Override
    public ImmutableMultimap<K, V> deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        ImmutableMultimap.Builder result = codedIn.readBool() ? ImmutableListMultimap.builder() : ImmutableSetMultimap.builder();
        int length = codedIn.readInt32();
        for (int i = 0; i < length; ++i) {
            Object key = context.deserialize(codedIn);
            Collection values = (Collection)context.deserialize(codedIn);
            result.putAll(key, values);
        }
        return result.build();
    }
}

