/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.collect.ImmutableList;
import com.google.devtools.build.lib.skyframe.serialization.CodecRegisterer;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.util.function.Supplier;

public final class MessageLiteCodec
implements ObjectCodec<MessageLite> {
    private final Supplier<MessageLite.Builder> builderSupplier;
    private final Class<? extends MessageLite> type;

    public MessageLiteCodec(Supplier<MessageLite.Builder> builderSupplier) {
        this.builderSupplier = builderSupplier;
        this.type = builderSupplier.get().buildPartial().getClass();
    }

    @Override
    public Class<? extends MessageLite> getEncodedClass() {
        return this.type;
    }

    @Override
    public void serialize(SerializationContext unusedContext, MessageLite message, CodedOutputStream codedOut) throws IOException, SerializationException {
        codedOut.writeMessageNoTag(message);
    }

    @Override
    public MessageLite deserialize(DeserializationContext unusedContext, CodedInputStream codedIn) throws IOException, SerializationException {
        codedIn.enableAliasing(false);
        try {
            MessageLite.Builder builder = this.builderSupplier.get();
            codedIn.readMessage(builder, ExtensionRegistryLite.getEmptyRegistry());
            MessageLite messageLite = builder.build();
            return messageLite;
        }
        catch (InvalidProtocolBufferException e) {
            throw new SerializationException("Failed to parse proto of type " + this.type, e);
        }
        finally {
            codedIn.enableAliasing(true);
        }
    }

    private static class MessageLiteCodecRegisterer
    implements CodecRegisterer {
        private MessageLiteCodecRegisterer() {
        }

        @Override
        public ImmutableList<ObjectCodec<?>> getCodecsToRegister() {
            return ImmutableList.of(new MessageLiteCodec(UnknownFieldSet::newBuilder));
        }
    }
}

