/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.collect.ImmutableList;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;

class ImmutableListCodec
implements ObjectCodec<ImmutableList> {
    ImmutableListCodec() {
    }

    @Override
    public Class<ImmutableList> getEncodedClass() {
        return ImmutableList.class;
    }

    @Override
    public void serialize(SerializationContext context, ImmutableList object, CodedOutputStream codedOut) throws IOException, SerializationException {
        codedOut.writeInt32NoTag(object.size());
        for (Object obj : object) {
            context.serialize(obj, codedOut);
        }
    }

    @Override
    public ImmutableList deserialize(DeserializationContext context, CodedInputStream codedIn) throws IOException, SerializationException {
        int size = codedIn.readInt32();
        Object[] list = new Object[size];
        for (int i = 0; i < size; ++i) {
            list[i] = context.deserialize(codedIn);
        }
        return ImmutableList.copyOf(list);
    }
}

