/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ImmutableMapCodec;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;

class ImmutableClassToInstanceMapCodec<B>
implements ObjectCodec<ImmutableClassToInstanceMap<B>> {
    ImmutableClassToInstanceMapCodec() {
    }

    @Override
    public Class<ImmutableClassToInstanceMap<B>> getEncodedClass() {
        return ImmutableClassToInstanceMap.class;
    }

    @Override
    public void serialize(SerializationContext context, ImmutableClassToInstanceMap<B> map, CodedOutputStream codedOut) throws SerializationException, IOException {
        codedOut.writeInt32NoTag(map.size());
        ImmutableMapCodec.serializeEntries(context, map.entrySet(), codedOut);
    }

    @Override
    public ImmutableClassToInstanceMap<B> deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        ImmutableMap classKeyedMap;
        int length = codedIn.readInt32();
        if (length < 0) {
            throw new SerializationException("Expected non-negative length: " + length);
        }
        ImmutableMap.Builder classKeyedBuilder = ImmutableMapCodec.deserializeEntries(ImmutableMap.builder(), length, context, codedIn);
        try {
            classKeyedMap = classKeyedBuilder.buildOrThrow();
        }
        catch (IllegalArgumentException e) {
            throw new SerializationException("Duplicate keys during ImmutableClassToInstanceMapCodec deserialization", e);
        }
        try {
            return ImmutableClassToInstanceMap.copyOf(classKeyedMap);
        }
        catch (ClassCastException e) {
            throw new SerializationException("Key-value type mismatch during ImmutableClassToInstanceMapCodec deserialization", e);
        }
    }
}

