/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.GoogleLogger;
import com.google.common.reflect.ClassPath;
import com.google.devtools.build.lib.skyframe.serialization.CodecRegisterer;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodecRegistry;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.RegisteredSingletonDoNotUse;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.function.Predicate;

final class CodecScanner {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();

    static ObjectCodecRegistry.Builder initializeCodecRegistry(Predicate<String> packageFilter) throws IOException, ReflectiveOperationException {
        ((GoogleLogger.Api)logger.atInfo()).log("Building ObjectCodecRegistry");
        ObjectCodecRegistry.Builder builder = ObjectCodecRegistry.newBuilder();
        for (ClassPath.ClassInfo classInfo : CodecScanner.getClassInfos(packageFilter)) {
            if (classInfo.getName().endsWith("Codec")) {
                CodecScanner.processLikelyCodec(classInfo.load(), builder);
                continue;
            }
            if (classInfo.getName().endsWith("CodecRegisterer")) {
                CodecScanner.processLikelyRegisterer(classInfo.load(), builder);
                continue;
            }
            if (classInfo.getName().endsWith("RegisteredSingleton")) {
                CodecScanner.processLikelyConstant(classInfo.load(), builder);
                continue;
            }
            builder.addClassName(classInfo.getName().intern());
        }
        return builder;
    }

    private static void processLikelyCodec(Class<?> type, ObjectCodecRegistry.Builder builder) throws ReflectiveOperationException {
        if (ObjectCodec.class.equals(type) || !ObjectCodec.class.isAssignableFrom(type) || Modifier.isAbstract(type.getModifiers())) {
            return;
        }
        try {
            Constructor<?> constructor = type.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            ObjectCodec codec = (ObjectCodec)constructor.newInstance(new Object[0]);
            if (codec.autoRegister()) {
                builder.add(codec);
            }
        }
        catch (NoSuchMethodException e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withCause(e)).log("Skipping registration of %s because it had no default constructor", type);
        }
    }

    private static void processLikelyRegisterer(Class<?> type, ObjectCodecRegistry.Builder builder) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        if (CodecRegisterer.class.equals(type) || !CodecRegisterer.class.isAssignableFrom(type)) {
            return;
        }
        Constructor<CodecRegisterer> constructor = type.asSubclass(CodecRegisterer.class).getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        CodecRegisterer registerer = constructor.newInstance(new Object[0]);
        for (ObjectCodec objectCodec : registerer.getCodecsToRegister()) {
            builder.add(objectCodec);
        }
    }

    private static void processLikelyConstant(Class<?> type, ObjectCodecRegistry.Builder builder) {
        Field field;
        if (!RegisteredSingletonDoNotUse.class.isAssignableFrom(type)) {
            return;
        }
        try {
            field = type.getDeclaredField("REGISTERED_SINGLETON_INSTANCE_VAR_NAME_GLFKMEBDQFHOJQKEHHQPGMNQBOBFEJADCMDP");
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(type + " inherits from " + RegisteredSingletonDoNotUse.class + " but does not have a field REGISTERED_SINGLETON_INSTANCE_VAR_NAME_GLFKMEBDQFHOJQKEHHQPGMNQBOBFEJADCMDP", e);
        }
        try {
            builder.addReferenceConstant(Preconditions.checkNotNull(field.get(null), "%s %s", (Object)field, type));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not access field " + field + " for " + type, e);
        }
    }

    private static ImmutableList<ClassPath.ClassInfo> getClassInfos(Predicate<String> packageFilter) throws IOException {
        return ClassPath.from(ClassLoader.getSystemClassLoader()).getResources().stream().filter(ClassPath.ClassInfo.class::isInstance).map(ClassPath.ClassInfo.class::cast).filter(c -> packageFilter.test(c.getPackageName())).sorted(Comparator.comparing(ClassPath.ClassInfo::getName)).collect(ImmutableList.toImmutableList());
    }

    private CodecScanner() {
    }
}

