/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;

class ClassCodec
implements ObjectCodec<Class<?>> {
    private static final ImmutableBiMap<Class<?>, Integer> PRIMITIVE_CLASS_INDEX_MAP = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put(Byte.TYPE, (Object)1)).put(Short.TYPE, (Object)2)).put(Integer.TYPE, (Object)3)).put(Long.TYPE, (Object)4)).put(Character.TYPE, (Object)5)).put(Float.TYPE, (Object)6)).put(Double.TYPE, (Object)7)).put(Boolean.TYPE, (Object)8)).put(Void.TYPE, (Object)9)).buildOrThrow();

    ClassCodec() {
    }

    @Override
    public Class<Class<?>> getEncodedClass() {
        return Class.class;
    }

    @Override
    public void serialize(SerializationContext context, Class<?> obj, CodedOutputStream codedOut) throws SerializationException, IOException {
        codedOut.writeBoolNoTag(obj.isPrimitive());
        if (obj.isPrimitive()) {
            codedOut.writeInt32NoTag(Preconditions.checkNotNull((Integer)PRIMITIVE_CLASS_INDEX_MAP.get(obj), obj));
        } else {
            context.serialize(obj.getName(), codedOut);
        }
    }

    @Override
    public Class<?> deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        boolean isPrimitive = codedIn.readBool();
        if (isPrimitive) {
            return (Class)((ImmutableMap)((Object)PRIMITIVE_CLASS_INDEX_MAP.inverse())).get(codedIn.readInt32());
        }
        String className = (String)context.deserialize(codedIn);
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException("Couldn't find class for " + className, e);
        }
    }
}

