/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.base.Predicates;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.devtools.build.lib.skyframe.serialization.CodecScanner;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodecRegistry;
import java.io.IOException;
import java.util.Comparator;
import java.util.function.Supplier;

public class AutoRegistry {
    private static final Supplier<ObjectCodecRegistry> SUPPLIER = Suppliers.memoize(AutoRegistry::create);
    private static final ImmutableList<String> CLASS_NAME_PREFIX_BLACKLIST = ImmutableList.of("com.google.devtools.build.lib.google", "com.google.devtools.build.lib.vfs", "com.google.devtools.build.lib.actions.ArtifactFactory", "com.google.devtools.build.lib.packages.PackageFactory$BuiltInRuleFunction", "com.google.devtools.build.skyframe.SkyFunctionEnvironment");
    private static final ImmutableList<String> EXTERNAL_CLASS_NAMES_TO_REGISTER = ImmutableList.of("java.io.FileNotFoundException", "java.io.IOException", "java.lang.StackTraceElement", "java.lang.invoke.SerializedLambda", "com.google.common.base.Predicates$InPredicate", "com.google.common.collect.ImmutableList$Builder");
    private static final ImmutableList<Object> REFERENCE_CONSTANTS_TO_REGISTER = ImmutableList.of(Predicates.alwaysTrue(), Predicates.alwaysFalse(), Predicates.isNull(), Predicates.notNull(), ImmutableList.of(), ImmutableSet.of(), Comparator.naturalOrder(), Ordering.natural());

    private static boolean packageFilter(String name) {
        return name.startsWith("com.google.devtools.build.lib") || name.startsWith("com.google.devtools.build.sky") || name.startsWith("com.google.devtools.common.options") || name.startsWith("net.starlark.java");
    }

    public static ObjectCodecRegistry get() {
        return SUPPLIER.get();
    }

    private static ObjectCodecRegistry create() {
        try {
            ObjectCodecRegistry.Builder registry = CodecScanner.initializeCodecRegistry(AutoRegistry::packageFilter);
            for (String string : EXTERNAL_CLASS_NAMES_TO_REGISTER) {
                registry.addClassName(string);
            }
            for (Object e : REFERENCE_CONSTANTS_TO_REGISTER) {
                registry.addReferenceConstant(e);
            }
            for (String string : CLASS_NAME_PREFIX_BLACKLIST) {
                registry.excludeClassNamePrefix(string);
            }
            return registry.build();
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }
}

