/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.devtools.build.lib.analysis.PlatformOptions;
import com.google.devtools.build.lib.analysis.config.BuildOptions;
import com.google.devtools.build.lib.analysis.config.FragmentOptions;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.skyframe.AutoValue_PlatformMappingValue_NativeAndStarlarkFlags;
import com.google.devtools.build.lib.skyframe.BuildConfigurationKey;
import com.google.devtools.build.lib.skyframe.SkyFunctions;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.AutoCodec;
import com.google.devtools.build.lib.vfs.PathFragment;
import com.google.devtools.build.skyframe.SkyFunctionName;
import com.google.devtools.build.skyframe.SkyKey;
import com.google.devtools.build.skyframe.SkyValue;
import com.google.devtools.common.options.OptionsParser;
import com.google.devtools.common.options.OptionsParsingException;
import com.google.devtools.common.options.OptionsParsingResult;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletionException;
import javax.annotation.Nullable;

@AutoCodec
public final class PlatformMappingValue
implements SkyValue {
    private final ImmutableMap<Label, NativeAndStarlarkFlags> platformsToFlags;
    private final ImmutableMap<ImmutableSet<String>, Label> flagsToPlatforms;
    private final ImmutableSet<Class<? extends FragmentOptions>> optionsClasses;
    private final LoadingCache<NativeAndStarlarkFlags, OptionsParsingResult> parserCache;
    private final LoadingCache<BuildConfigurationKey, BuildConfigurationKey> mappingCache;

    PlatformMappingValue(ImmutableMap<Label, NativeAndStarlarkFlags> platformsToFlags, ImmutableMap<ImmutableSet<String>, Label> flagsToPlatforms, ImmutableSet<Class<? extends FragmentOptions>> optionsClasses) {
        this.platformsToFlags = Preconditions.checkNotNull(platformsToFlags);
        this.flagsToPlatforms = Preconditions.checkNotNull(flagsToPlatforms);
        this.optionsClasses = Preconditions.checkNotNull(optionsClasses);
        this.parserCache = Caffeine.newBuilder().initialCapacity(platformsToFlags.size() + flagsToPlatforms.size()).build(this::parse);
        this.mappingCache = Caffeine.newBuilder().weakKeys().build(this::computeMapping);
    }

    public BuildConfigurationKey map(BuildConfigurationKey original) throws OptionsParsingException {
        try {
            return this.mappingCache.get(original);
        }
        catch (CompletionException e) {
            Throwables.propagateIfPossible(e.getCause(), OptionsParsingException.class);
            throw e;
        }
    }

    private BuildConfigurationKey computeMapping(BuildConfigurationKey original) throws OptionsParsingException {
        BuildOptions originalOptions = original.getOptions();
        if (originalOptions.hasNoConfig()) {
            return original;
        }
        Preconditions.checkArgument(originalOptions.contains(PlatformOptions.class), "When using platform mappings, all configurations must contain platform options");
        BuildOptions modifiedOptions = null;
        if (!originalOptions.get(PlatformOptions.class).platforms.isEmpty()) {
            List<Label> platforms = originalOptions.get(PlatformOptions.class).platforms;
            Label targetPlatform = Iterables.getFirst(platforms, null);
            if (!this.platformsToFlags.containsKey(targetPlatform)) {
                return original;
            }
            modifiedOptions = originalOptions.applyParsingResult(this.parseWithCache(this.platformsToFlags.get(targetPlatform)));
        } else {
            boolean mappingFound = false;
            for (Map.Entry flagsToPlatform : this.flagsToPlatforms.entrySet()) {
                if (!originalOptions.matches(this.parseWithCache(NativeAndStarlarkFlags.create((ImmutableSet)flagsToPlatform.getKey(), ImmutableMap.of())))) continue;
                modifiedOptions = originalOptions.clone();
                modifiedOptions.get(PlatformOptions.class).platforms = ImmutableList.of((Label)flagsToPlatform.getValue());
                mappingFound = true;
                break;
            }
            if (!mappingFound) {
                Label targetPlatform = originalOptions.get(PlatformOptions.class).computeTargetPlatform();
                modifiedOptions = originalOptions.clone();
                modifiedOptions.get(PlatformOptions.class).platforms = ImmutableList.of(targetPlatform);
            }
        }
        return BuildConfigurationKey.withoutPlatformMapping(modifiedOptions);
    }

    private OptionsParsingResult parseWithCache(NativeAndStarlarkFlags args) throws OptionsParsingException {
        try {
            return this.parserCache.get(args);
        }
        catch (CompletionException e) {
            Throwables.propagateIfPossible(e.getCause(), OptionsParsingException.class);
            throw e;
        }
    }

    private OptionsParsingResult parse(NativeAndStarlarkFlags args) throws OptionsParsingException {
        OptionsParser parser = OptionsParser.builder().optionsClasses(this.optionsClasses).ignoreInternalOptions(false).build();
        parser.parse(args.nativeFlags().asList());
        parser.setStarlarkOptions(args.starlarkFlags());
        return parser;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PlatformMappingValue)) {
            return false;
        }
        PlatformMappingValue that = (PlatformMappingValue)obj;
        return this.flagsToPlatforms.equals(that.flagsToPlatforms) && this.platformsToFlags.equals(that.platformsToFlags) && this.optionsClasses.equals(that.optionsClasses);
    }

    public int hashCode() {
        return Objects.hash(this.flagsToPlatforms, this.platformsToFlags, this.optionsClasses);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("flagsToPlatforms", this.flagsToPlatforms).add("platformsToFlags", this.platformsToFlags).add("optionsClasses", this.optionsClasses).toString();
    }

    @AutoValue
    static abstract class NativeAndStarlarkFlags {
        NativeAndStarlarkFlags() {
        }

        abstract ImmutableSet<String> nativeFlags();

        abstract ImmutableMap<String, Object> starlarkFlags();

        static NativeAndStarlarkFlags create(ImmutableSet<String> nativeFlags, ImmutableMap<String, Object> starlarkFlags) {
            return new AutoValue_PlatformMappingValue_NativeAndStarlarkFlags(nativeFlags, starlarkFlags);
        }
    }

    @AutoCodec
    public static final class Key
    implements SkyKey {
        private static final SkyKey.SkyKeyInterner<Key> interner = SkyKey.newInterner();
        private final PathFragment path;
        private final boolean wasExplicitlySetByUser;

        public static Key create(@Nullable PathFragment workspaceRelativeMappingPath) {
            if (workspaceRelativeMappingPath == null) {
                return Key.create(PlatformOptions.DEFAULT_PLATFORM_MAPPINGS, false);
            }
            return Key.create(workspaceRelativeMappingPath, true);
        }

        @AutoCodec.Instantiator
        @AutoCodec.VisibleForSerialization
        static Key create(PathFragment workspaceRelativeMappingPath, boolean wasExplicitlySetByUser) {
            return interner.intern(new Key(workspaceRelativeMappingPath, wasExplicitlySetByUser));
        }

        private Key(PathFragment path, boolean wasExplicitlySetByUser) {
            this.path = path;
            this.wasExplicitlySetByUser = wasExplicitlySetByUser;
        }

        public PathFragment getWorkspaceRelativeMappingPath() {
            return this.path;
        }

        boolean wasExplicitlySetByUser() {
            return this.wasExplicitlySetByUser;
        }

        @Override
        public SkyFunctionName functionName() {
            return SkyFunctions.PLATFORM_MAPPING;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.path, key.path) && this.wasExplicitlySetByUser == key.wasExplicitlySetByUser;
        }

        public int hashCode() {
            return Objects.hash(this.path, this.wasExplicitlySetByUser);
        }

        public String toString() {
            return "PlatformMappingValue.Key{path=" + this.path + ", wasExplicitlySetByUser=" + this.wasExplicitlySetByUser + "}";
        }

        public SkyKey.SkyKeyInterner<Key> getSkyKeyInterner() {
            return interner;
        }
    }
}

