/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe;

import com.google.common.base.Preconditions;
import com.google.devtools.build.lib.analysis.config.BuildOptions;
import com.google.devtools.build.lib.skyframe.PlatformMappingValue;
import com.google.devtools.build.lib.skyframe.SkyFunctions;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.AutoCodec;
import com.google.devtools.build.skyframe.SkyFunctionName;
import com.google.devtools.build.skyframe.SkyKey;
import com.google.devtools.common.options.OptionsParsingException;

@AutoCodec
public final class BuildConfigurationKey
implements SkyKey {
    private static final SkyKey.SkyKeyInterner<BuildConfigurationKey> interner = SkyKey.newInterner();
    private final BuildOptions options;

    public static BuildConfigurationKey withPlatformMapping(PlatformMappingValue platformMappingValue, BuildOptions options) throws OptionsParsingException {
        return platformMappingValue.map(BuildConfigurationKey.withoutPlatformMapping(options));
    }

    @AutoCodec.Instantiator
    public static BuildConfigurationKey withoutPlatformMapping(BuildOptions options) {
        return interner.intern(new BuildConfigurationKey(options));
    }

    private BuildConfigurationKey(BuildOptions options) {
        this.options = Preconditions.checkNotNull(options);
    }

    public BuildOptions getOptions() {
        return this.options;
    }

    @Override
    public SkyFunctionName functionName() {
        return SkyFunctions.BUILD_CONFIGURATION;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BuildConfigurationKey)) {
            return false;
        }
        BuildConfigurationKey otherConfig = (BuildConfigurationKey)o;
        return this.options.equals(otherConfig.options);
    }

    public int hashCode() {
        return this.options.hashCode();
    }

    public String toString() {
        return "BuildConfigurationKey[" + this.options.checksum() + "]";
    }

    public SkyKey.SkyKeyInterner<BuildConfigurationKey> getSkyKeyInterner() {
        return interner;
    }
}

