/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.profiler;

import java.time.Duration;
import java.util.Arrays;

public class TimeSeries {
    private final Duration startTime;
    private final long bucketSizeMillis;
    private static final int INITIAL_SIZE = 100;
    private double[] data = new double[100];

    public TimeSeries(Duration startTime, Duration bucketDuration) {
        this.startTime = startTime;
        this.bucketSizeMillis = bucketDuration.toMillis();
    }

    public void addRange(Duration startTime, Duration endTime) {
        this.addRange(startTime, endTime, 1.0);
    }

    public void addRange(Duration rangeStart, Duration rangeEnd, double value) {
        rangeStart = rangeStart.minus(this.startTime);
        rangeEnd = rangeEnd.minus(this.startTime);
        int startPosition = (int)(rangeStart.toMillis() / this.bucketSizeMillis);
        int endPosition = (int)(rangeEnd.toMillis() / this.bucketSizeMillis);
        double missingStartFraction = (double)rangeStart.minusMillis(this.bucketSizeMillis * (long)startPosition).toMillis() / (double)this.bucketSizeMillis;
        double missingEndFraction = (double)(this.bucketSizeMillis * (long)(endPosition + 1) - rangeEnd.toMillis()) / (double)this.bucketSizeMillis;
        if (startPosition < 0) {
            startPosition = 0;
            missingStartFraction = 0.0;
        }
        if (endPosition < startPosition) {
            endPosition = startPosition;
            missingEndFraction = 0.0;
        }
        if (endPosition >= this.data.length) {
            this.data = Arrays.copyOf(this.data, Math.max(endPosition + 1, 2 * this.data.length));
        }
        int i = startPosition;
        while (i <= endPosition) {
            double fraction = 1.0;
            if (i == startPosition) {
                fraction -= missingStartFraction;
            }
            if (i == endPosition) {
                fraction -= missingEndFraction;
            }
            int n = i++;
            this.data[n] = this.data[n] + fraction * value;
        }
    }

    public double[] toDoubleArray(int len) {
        return Arrays.copyOf(this.data, len);
    }
}

