/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.profiler;

import com.google.devtools.build.lib.profiler.TraceData;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ThreadMetadata
implements TraceData {
    private final String readableName;
    private final long threadId;
    private final long sortIndex;
    static final long CRITICAL_PATH_THREAD_ID = 0L;
    private static final long SKYFRAME_EVALUATOR_SHIFT = 10000L;
    private static final long DYNAMIC_EXECUTION_SHIFT = 20000L;
    private static final long INCLUDE_SCANNER_SHIFT = 30000L;
    private static final long CRITICAL_PATH_SORT_INDEX = 0L;
    private static final long MAIN_THREAD_SORT_INDEX = 1L;
    private static final long GC_THREAD_SORT_INDEX = 2L;
    private static final long MAX_SORT_INDEX = 1000000L;
    private static final Pattern NUMBER_PATTERN = Pattern.compile("\\d+");

    private ThreadMetadata(String readableName, long threadId, long sortIndex) {
        this.readableName = readableName;
        this.threadId = threadId;
        this.sortIndex = sortIndex;
    }

    public ThreadMetadata() {
        this.readableName = ThreadMetadata.getReadableName(Thread.currentThread().getName());
        this.threadId = Thread.currentThread().getId();
        this.sortIndex = ThreadMetadata.getSortIndex(Thread.currentThread().getName());
    }

    public static ThreadMetadata createFakeThreadMetadataForCriticalPath() {
        return new ThreadMetadata("Critical Path", 0L, 0L);
    }

    private static boolean isMainThread(String threadName) {
        return threadName.startsWith("grpc-command");
    }

    private static boolean isGCThread(String threadName) {
        return threadName.equals("Service Thread");
    }

    private static String getReadableName(String threadName) {
        if (ThreadMetadata.isMainThread(threadName)) {
            return "Main Thread";
        }
        if (ThreadMetadata.isGCThread(threadName)) {
            return "Garbage Collector";
        }
        return threadName;
    }

    private static long getSortIndex(String threadName) {
        long extractedNumber;
        if (ThreadMetadata.isMainThread(threadName)) {
            return 1L;
        }
        if (ThreadMetadata.isGCThread(threadName)) {
            return 2L;
        }
        Matcher numberMatcher = NUMBER_PATTERN.matcher(threadName);
        if (!numberMatcher.find()) {
            return 1000000L;
        }
        try {
            extractedNumber = Long.parseLong(numberMatcher.group());
        }
        catch (NumberFormatException e) {
            return 1000000L;
        }
        if (threadName.startsWith("skyframe-evaluator")) {
            return 10000L + extractedNumber;
        }
        if (threadName.startsWith("dynamic-execution")) {
            return 20000L + extractedNumber;
        }
        if (threadName.startsWith("Include scanner")) {
            return 30000L + extractedNumber;
        }
        return 1000000L;
    }

    @Override
    public void writeTraceData(JsonWriter jsonWriter, long profileStartTimeNanos) throws IOException {
        jsonWriter.setIndent("  ");
        jsonWriter.beginObject();
        jsonWriter.setIndent("");
        jsonWriter.name("name").value("thread_name");
        jsonWriter.name("ph").value("M");
        jsonWriter.name("pid").value(1L);
        jsonWriter.name("tid").value(this.threadId);
        jsonWriter.name("args");
        jsonWriter.beginObject();
        jsonWriter.name("name").value(this.readableName);
        jsonWriter.endObject();
        jsonWriter.endObject();
        jsonWriter.setIndent("  ");
        jsonWriter.beginObject();
        jsonWriter.setIndent("");
        jsonWriter.name("name").value("thread_sort_index");
        jsonWriter.name("ph").value("M");
        jsonWriter.name("pid").value(1L);
        jsonWriter.name("tid").value(this.threadId);
        jsonWriter.name("args");
        jsonWriter.beginObject();
        jsonWriter.name("sort_index").value(this.sortIndex);
        jsonWriter.endObject();
        jsonWriter.endObject();
    }
}

