/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.profiler;

import com.google.auto.value.AutoValue;
import com.google.common.base.Splitter;
import com.google.devtools.build.lib.jni.JniLoader;
import com.google.devtools.build.lib.profiler.AutoValue_SystemNetworkStats_NetIfAddr;
import com.google.devtools.build.lib.profiler.AutoValue_SystemNetworkStats_NetIoCounter;
import com.google.devtools.build.lib.util.OS;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SystemNetworkStats {
    private static final Splitter SPLITTER = Splitter.on(" ").omitEmptyStrings().trimResults();

    private SystemNetworkStats() {
    }

    public static Map<String, NetIoCounter> getNetIoCounters() throws IOException {
        HashMap<String, NetIoCounter> counters = new HashMap<String, NetIoCounter>();
        switch (OS.getCurrent()) {
            case LINUX: {
                SystemNetworkStats.getNetIoCountersLinux(counters);
                break;
            }
            default: {
                SystemNetworkStats.getNetIoCountersNative(counters);
            }
        }
        return counters;
    }

    private static void getNetIoCountersLinux(Map<String, NetIoCounter> counters) throws IOException {
        List<String> lines = Files.readAllLines(Paths.get("/proc/net/dev", new String[0]), StandardCharsets.UTF_8);
        for (String line : lines.subList(2, lines.size())) {
            int colonAt = line.indexOf(58);
            if (colonAt < 0) continue;
            String name = line.substring(0, colonAt).strip();
            long[] fields = SPLITTER.splitToStream(line.substring(colonAt + 1)).mapToLong(Long::parseLong).toArray();
            if (fields.length <= 9) continue;
            long bytesRecv = fields[0];
            long packetsRecv = fields[1];
            long bytesSent = fields[8];
            long packetsSent = fields[9];
            counters.put(name, NetIoCounter.create(bytesSent, bytesRecv, packetsSent, packetsRecv));
        }
    }

    public static Map<String, List<NetIfAddr>> getNetIfAddrs() throws IOException {
        ArrayList<NetIfAddr> addrs = new ArrayList<NetIfAddr>();
        SystemNetworkStats.getNetIfAddrsNative(addrs);
        HashMap<String, List<NetIfAddr>> result = new HashMap<String, List<NetIfAddr>>();
        for (NetIfAddr addr : addrs) {
            result.computeIfAbsent(addr.name(), ignored -> new ArrayList()).add(addr);
        }
        return result;
    }

    private static native void getNetIoCountersNative(Map<String, NetIoCounter> var0) throws IOException;

    private static native void getNetIfAddrsNative(List<NetIfAddr> var0) throws IOException;

    static {
        JniLoader.loadJni();
    }

    @AutoValue
    public static abstract class NetIfAddr {
        public static NetIfAddr create(String name, Family family, String ipAddr) {
            return new AutoValue_SystemNetworkStats_NetIfAddr(name, family, ipAddr);
        }

        public abstract String name();

        public abstract Family family();

        public abstract String ipAddr();

        public static enum Family {
            AF_INET,
            AF_INET6,
            UNKNOWN;

        }
    }

    @AutoValue
    public static abstract class NetIoCounter {
        public static NetIoCounter create(long bytesSent, long bytesRecv, long packetsSent, long packetsRecv) {
            return new AutoValue_SystemNetworkStats_NetIoCounter(bytesSent, bytesRecv, packetsSent, packetsRecv);
        }

        public abstract long bytesSent();

        public abstract long bytesRecv();

        public abstract long packetsSent();

        public abstract long packetsRecv();
    }
}

