/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.profiler;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.devtools.build.lib.profiler.MetricData;
import com.google.devtools.build.lib.profiler.StatRecorder;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAccumulator;

public class SingleStatRecorder
implements StatRecorder {
    private final int buckets;
    private final Object description;
    private final AtomicIntegerArray histogram;
    private final AtomicLong sum = new AtomicLong(0L);
    private final AtomicLong sumSquared = new AtomicLong(0L);
    private final LongAccumulator max = new LongAccumulator(Math::max, -1L);

    public SingleStatRecorder(Object description, int buckets) {
        this.description = description;
        Preconditions.checkArgument(buckets > 1, "At least two buckets (one for bellow start and onefor above start) are required");
        this.buckets = buckets;
        this.histogram = new AtomicIntegerArray(buckets);
    }

    public MetricData snapshot() {
        ImmutableList.Builder result = ImmutableList.builder();
        result.add(new MetricData.HistogramElement(Range.closedOpen(0, 1), this.histogram.get(0)));
        int from = 1;
        for (int i = 1; i < this.histogram.length() - 1; ++i) {
            int to = from << 1;
            result.add(new MetricData.HistogramElement(Range.closedOpen(from, to), this.histogram.get(i)));
            from = to;
        }
        result.add(new MetricData.HistogramElement(Range.atLeast(from), this.histogram.get(this.histogram.length() - 1)));
        int n = 0;
        for (int i = 0; i < this.histogram.length(); ++i) {
            n += this.histogram.get(i);
        }
        double stddev = n == 1 ? 0.0 : Math.sqrt(((double)this.sumSquared.longValue() - (double)this.sum.get() * this.sum.doubleValue() / (double)n) / (double)n);
        return new MetricData(this.description, (ImmutableList<MetricData.HistogramElement>)result.build(), n, this.sum.doubleValue() / (double)n, stddev, this.max.intValue());
    }

    @Override
    public void addStat(int duration, Object obj) {
        int histogramBucket = Math.min(32 - Integer.numberOfLeadingZeros(duration), this.buckets - 1);
        this.sum.addAndGet(duration);
        this.sumSquared.addAndGet(duration * duration);
        this.max.accumulate(duration);
        this.histogram.incrementAndGet(histogramBucket);
    }

    @Override
    public boolean isEmpty() {
        return this.snapshot().getCount() == 0;
    }

    public String toString() {
        return this.snapshot().toString();
    }
}

