/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.profiler;

import com.google.common.base.Predicate;
import com.google.devtools.build.lib.profiler.StatRecorder;
import java.util.List;

public class PredicateBasedStatRecorder
implements StatRecorder {
    private final Predicate<? super String>[] predicates;
    private final StatRecorder[] recorders;

    public PredicateBasedStatRecorder(List<RecorderAndPredicate> stats) {
        this.predicates = new Predicate[stats.size()];
        this.recorders = new StatRecorder[stats.size()];
        for (int i = 0; i < stats.size(); ++i) {
            RecorderAndPredicate stat = stats.get(i);
            this.predicates[i] = stat.predicate;
            this.recorders[i] = stat.recorder;
        }
    }

    @Override
    public void addStat(int duration, Object obj) {
        String description = obj.toString();
        for (int i = 0; i < this.predicates.length; ++i) {
            if (!this.predicates[i].apply(description)) continue;
            this.recorders[i].addStat(duration, obj);
            return;
        }
    }

    @Override
    public boolean isEmpty() {
        for (StatRecorder recorder : this.recorders) {
            if (recorder.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (StatRecorder recorder : this.recorders) {
            if (recorder.isEmpty()) continue;
            sb.append(recorder);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static final class RecorderAndPredicate {
        private final StatRecorder recorder;
        private final Predicate<? super String> predicate;

        public RecorderAndPredicate(StatRecorder recorder, Predicate<? super String> predicate) {
            this.recorder = recorder;
            this.predicate = predicate;
        }
    }
}

