/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.profiler;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.common.flogger.GoogleLogger;
import com.google.devtools.build.lib.buildeventstream.BuildEventStreamProtos;
import com.google.devtools.build.lib.profiler.AutoValue_NetworkMetricsCollector_SystemNetworkUsages;
import com.google.devtools.build.lib.profiler.SystemNetworkStats;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class NetworkMetricsCollector {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final NetworkMetricsCollector instance = new NetworkMetricsCollector();
    @Nullable
    private ImmutableSet<String> localLoopbackInterfaces = null;
    @Nullable
    private Map<String, SystemNetworkStats.NetIoCounter> previousNetworkIoCounters = null;
    private final BuildEventStreamProtos.BuildMetrics.NetworkMetrics.SystemNetworkStats.Builder systemNetworkStats = BuildEventStreamProtos.BuildMetrics.NetworkMetrics.SystemNetworkStats.newBuilder();

    private NetworkMetricsCollector() {
    }

    public static NetworkMetricsCollector instance() {
        return instance;
    }

    @Nullable
    public BuildEventStreamProtos.BuildMetrics.NetworkMetrics collectMetrics() {
        if (this.systemNetworkStats.getBytesRecv() == 0L || this.systemNetworkStats.getBytesSent() == 0L) {
            return null;
        }
        return BuildEventStreamProtos.BuildMetrics.NetworkMetrics.newBuilder().setSystemNetworkStats(this.systemNetworkStats.build()).build();
    }

    @Nullable
    public SystemNetworkUsages collectSystemNetworkUsages(double deltaNanos) {
        Map<String, SystemNetworkStats.NetIoCounter> nextNetworkIoCounters = null;
        try {
            nextNetworkIoCounters = SystemNetworkStats.getNetIoCounters();
        }
        catch (IOException e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).log("Failed to get Net IO counters");
        }
        if (this.previousNetworkIoCounters == null) {
            this.previousNetworkIoCounters = nextNetworkIoCounters;
        }
        SystemNetworkUsages usages = null;
        if (this.previousNetworkIoCounters != null && nextNetworkIoCounters != null) {
            if (this.localLoopbackInterfaces == null) {
                this.localLoopbackInterfaces = this.getLocalLoopbackInterfaces();
            }
            long deltaBytesSent = 0L;
            long deltaBytesRecv = 0L;
            long deltaPacketsSent = 0L;
            long deltaPacketsRecv = 0L;
            for (Map.Entry<String, SystemNetworkStats.NetIoCounter> entry : this.previousNetworkIoCounters.entrySet()) {
                String name = entry.getKey();
                if (this.localLoopbackInterfaces.contains(name)) continue;
                SystemNetworkStats.NetIoCounter previous = entry.getValue();
                SystemNetworkStats.NetIoCounter next = nextNetworkIoCounters.get(name);
                if (next == null) continue;
                deltaBytesSent += NetworkMetricsCollector.calcDelta(previous.bytesSent(), next.bytesSent());
                deltaBytesRecv += NetworkMetricsCollector.calcDelta(previous.bytesRecv(), next.bytesRecv());
                deltaPacketsSent += NetworkMetricsCollector.calcDelta(previous.packetsSent(), next.packetsSent());
                deltaPacketsRecv += NetworkMetricsCollector.calcDelta(previous.packetsRecv(), next.packetsRecv());
            }
            this.systemNetworkStats.setBytesRecv(this.systemNetworkStats.getBytesRecv() + deltaBytesRecv);
            this.systemNetworkStats.setBytesSent(this.systemNetworkStats.getBytesSent() + deltaBytesSent);
            this.systemNetworkStats.setPacketsRecv(this.systemNetworkStats.getPacketsRecv() + deltaPacketsRecv);
            this.systemNetworkStats.setPacketsSent(this.systemNetworkStats.getPacketsSent() + deltaPacketsSent);
            usages = SystemNetworkUsages.create(NetworkMetricsCollector.calcValuePerSec(deltaBytesSent, deltaNanos), NetworkMetricsCollector.calcValuePerSec(deltaBytesRecv, deltaNanos), NetworkMetricsCollector.calcValuePerSec(deltaPacketsSent, deltaNanos), NetworkMetricsCollector.calcValuePerSec(deltaPacketsRecv, deltaNanos));
            if (usages.bytesSentPerSec() > (double)this.systemNetworkStats.getPeakBytesSentPerSec()) {
                this.systemNetworkStats.setPeakBytesSentPerSec((long)usages.bytesSentPerSec());
            }
            if (usages.bytesRecvPerSec() > (double)this.systemNetworkStats.getPeakBytesRecvPerSec()) {
                this.systemNetworkStats.setPeakBytesRecvPerSec((long)usages.bytesRecvPerSec());
            }
            if (usages.packetsSentPerSec() > (double)this.systemNetworkStats.getPeakPacketsSentPerSec()) {
                this.systemNetworkStats.setPeakPacketsSentPerSec((long)usages.packetsSentPerSec());
            }
            if (usages.packetsRecvPerSec() > (double)this.systemNetworkStats.getPeakPacketsRecvPerSec()) {
                this.systemNetworkStats.setPeakPacketsRecvPerSec((long)usages.packetsRecvPerSec());
            }
        }
        this.previousNetworkIoCounters = nextNetworkIoCounters;
        return usages;
    }

    private ImmutableSet<String> getLocalLoopbackInterfaces() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        try {
            for (Map.Entry<String, List<SystemNetworkStats.NetIfAddr>> entry : SystemNetworkStats.getNetIfAddrs().entrySet()) {
                if (!this.isLocalLoopback(entry.getValue())) continue;
                result.add(entry.getKey());
            }
        }
        catch (IOException e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).log("Failed to query network interfaces");
        }
        return result.build();
    }

    private boolean isLocalLoopback(List<SystemNetworkStats.NetIfAddr> addresses) {
        for (SystemNetworkStats.NetIfAddr addr : addresses) {
            switch (addr.family()) {
                case AF_INET: {
                    if (!addr.ipAddr().equals("127.0.0.1")) break;
                    return true;
                }
                case AF_INET6: {
                    if (!addr.ipAddr().equals("::1")) break;
                    return true;
                }
            }
        }
        return false;
    }

    private static long calcDelta(long prev, long next) {
        if (next < prev) {
            return next;
        }
        return next - prev;
    }

    private static double calcValuePerSec(long deltaValue, double deltaNanos) {
        return (double)deltaValue / deltaNanos * 1.0E9;
    }

    private static double bytesPerSecToMegabitsPerSec(double bytesPerSec) {
        return bytesPerSec / 1000000.0 * 8.0;
    }

    @AutoValue
    public static abstract class SystemNetworkUsages {
        public static SystemNetworkUsages create(double bytesSentPerSec, double bytesRecvPerSec, double packetsSentPerSec, double packetsRecvPerSec) {
            return new AutoValue_NetworkMetricsCollector_SystemNetworkUsages(bytesSentPerSec, bytesRecvPerSec, packetsSentPerSec, packetsRecvPerSec);
        }

        public abstract double bytesSentPerSec();

        public abstract double bytesRecvPerSec();

        public abstract double packetsSentPerSec();

        public abstract double packetsRecvPerSec();

        public double megabitsSentPerSec() {
            return NetworkMetricsCollector.bytesPerSecToMegabitsPerSec(this.bytesSentPerSec());
        }

        public double megabitsRecvPerSec() {
            return NetworkMetricsCollector.bytesPerSecToMegabitsPerSec(this.bytesRecvPerSec());
        }
    }
}

