/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.profiler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.stream.Collectors;

public final class MetricData {
    private final Object description;
    private final ImmutableList<HistogramElement> histogram;
    private final int count;
    private final double avg;
    private final double stdDev;
    private final int max;

    public MetricData(Object description, ImmutableList<HistogramElement> histogram, int count, double avg, double stdDev, int max) {
        this.description = description;
        this.histogram = histogram;
        this.count = count;
        this.avg = avg;
        this.stdDev = stdDev;
        this.max = max;
    }

    public Object getDescription() {
        return this.description;
    }

    public ImmutableList<HistogramElement> getHistogram() {
        return this.histogram;
    }

    public int getCount() {
        return this.count;
    }

    public double getAvg() {
        return this.avg;
    }

    public double getStdDev() {
        return this.stdDev;
    }

    public int getMax() {
        return this.max;
    }

    public String toString() {
        if (this.count == 0) {
            return "'" + this.description + "'. Zero data recorded";
        }
        DecimalFormat fmt = new DecimalFormat("0.###", new DecimalFormatSymbols(Locale.US));
        return "'" + this.description + "'.  Count: " + this.count + " Avg: " + fmt.format(this.avg) + " StdDev: " + fmt.format(this.stdDev) + " Max: " + this.max + " Histogram:\n  " + this.histogram.stream().filter(element -> element.count > 0).map(Object::toString).collect(Collectors.joining("\n  "));
    }

    public static final class HistogramElement {
        private final Range<Integer> range;
        private final int count;

        HistogramElement(Range<Integer> range, int count) {
            this.range = range;
            this.count = count;
        }

        public Range<Integer> getRange() {
            return this.range;
        }

        public int getCount() {
            return this.count;
        }

        public String toString() {
            return String.format("%-15s:%10s", "[" + this.range.lowerEndpoint() + ".." + (Serializable)(this.range.hasUpperBound() ? (Serializable)this.range.upperEndpoint() : "\u221e") + " ms]", this.count);
        }
    }
}

