/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.profiler;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.devtools.build.lib.profiler.AutoValue_MemoryProfiler_HeapAndNonHeap;
import com.google.devtools.build.lib.profiler.ProfilePhase;
import com.google.devtools.build.lib.util.Pair;
import com.google.devtools.common.options.Converter;
import com.google.devtools.common.options.OptionsParsingException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

public final class MemoryProfiler {
    private static final MemoryProfiler INSTANCE = new MemoryProfiler();
    private PrintStream memoryProfile;
    private ProfilePhase currentPhase;
    private long heapUsedMemoryAtFinish;
    @Nullable
    private MemoryProfileStableHeapParameters memoryProfileStableHeapParameters;

    public static MemoryProfiler instance() {
        return INSTANCE;
    }

    public synchronized void setStableMemoryParameters(MemoryProfileStableHeapParameters memoryProfileStableHeapParameters) {
        this.memoryProfileStableHeapParameters = memoryProfileStableHeapParameters;
    }

    public synchronized void start(OutputStream out) {
        this.memoryProfile = out == null ? null : new PrintStream(out);
        this.currentPhase = ProfilePhase.INIT;
        this.heapUsedMemoryAtFinish = 0L;
    }

    public synchronized void stop() {
        if (this.memoryProfile != null) {
            this.memoryProfile.close();
            this.memoryProfile = null;
        }
        this.heapUsedMemoryAtFinish = 0L;
    }

    public synchronized long getHeapUsedMemoryAtFinish() {
        return this.heapUsedMemoryAtFinish;
    }

    public synchronized void markPhase(ProfilePhase nextPhase) throws InterruptedException {
        if (this.memoryProfile != null) {
            MemoryMXBean bean = ManagementFactory.getMemoryMXBean();
            HeapAndNonHeap memoryUsages = this.prepareBeanAndGetLocalMinUsage(nextPhase, bean, duration -> Thread.sleep(duration.toMillis()));
            String name = this.currentPhase.description;
            MemoryUsage memoryUsage = memoryUsages.getHeap();
            this.memoryProfile.println(name + ":heap:init:" + memoryUsage.getInit());
            this.memoryProfile.println(name + ":heap:used:" + memoryUsage.getUsed());
            this.memoryProfile.println(name + ":heap:commited:" + memoryUsage.getCommitted());
            this.memoryProfile.println(name + ":heap:max:" + memoryUsage.getMax());
            if (nextPhase == ProfilePhase.FINISH) {
                this.heapUsedMemoryAtFinish = memoryUsage.getUsed();
            }
            memoryUsage = memoryUsages.getNonHeap();
            this.memoryProfile.println(name + ":non-heap:init:" + memoryUsage.getInit());
            this.memoryProfile.println(name + ":non-heap:used:" + memoryUsage.getUsed());
            this.memoryProfile.println(name + ":non-heap:commited:" + memoryUsage.getCommitted());
            this.memoryProfile.println(name + ":non-heap:max:" + memoryUsage.getMax());
            this.currentPhase = nextPhase;
        }
    }

    @VisibleForTesting
    synchronized HeapAndNonHeap prepareBeanAndGetLocalMinUsage(ProfilePhase nextPhase, MemoryMXBean bean, Sleeper sleeper) throws InterruptedException {
        bean.gc();
        MemoryUsage minHeapUsed = bean.getHeapMemoryUsage();
        MemoryUsage minNonHeapUsed = bean.getNonHeapMemoryUsage();
        if (nextPhase == ProfilePhase.FINISH && this.memoryProfileStableHeapParameters != null) {
            for (int j = 0; j < this.memoryProfileStableHeapParameters.gcSpecs.size(); ++j) {
                Pair<Integer, Duration> spec = this.memoryProfileStableHeapParameters.gcSpecs.get(j);
                int numTimesToDoGc = (Integer)spec.first;
                Duration timeToSleepBetweenGcs = (Duration)spec.second;
                for (int i = 0; i < numTimesToDoGc; ++i) {
                    if (j == 0 && i == 0) continue;
                    sleeper.sleep(timeToSleepBetweenGcs);
                    bean.gc();
                    MemoryUsage currentHeapUsed = bean.getHeapMemoryUsage();
                    if (currentHeapUsed.getUsed() >= minHeapUsed.getUsed()) continue;
                    minHeapUsed = currentHeapUsed;
                    minNonHeapUsed = bean.getNonHeapMemoryUsage();
                }
            }
        }
        return HeapAndNonHeap.create(minHeapUsed, minNonHeapUsed);
    }

    @VisibleForTesting
    @AutoValue
    static abstract class HeapAndNonHeap {
        HeapAndNonHeap() {
        }

        abstract MemoryUsage getHeap();

        abstract MemoryUsage getNonHeap();

        static HeapAndNonHeap create(MemoryUsage heap, MemoryUsage nonHeap) {
            return new AutoValue_MemoryProfiler_HeapAndNonHeap(heap, nonHeap);
        }
    }

    @VisibleForTesting
    static interface Sleeper {
        public void sleep(Duration var1) throws InterruptedException;
    }

    public static class MemoryProfileStableHeapParameters {
        private final ArrayList<Pair<Integer, Duration>> gcSpecs;

        private MemoryProfileStableHeapParameters(ArrayList<Pair<Integer, Duration>> gcSpecs) {
            this.gcSpecs = gcSpecs;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("gcSpecs", this.gcSpecs).toString();
        }

        public static class Converter
        extends Converter.Contextless<MemoryProfileStableHeapParameters> {
            private static final Splitter SPLITTER = Splitter.on(',');

            @Override
            public MemoryProfileStableHeapParameters convert(String input) throws OptionsParsingException {
                List<String> values = SPLITTER.splitToList(input);
                if (values.size() % 2 != 0) {
                    throw new OptionsParsingException("Expected even number of comma-separated integer values");
                }
                ArrayList<Pair<Integer, Duration>> gcSpecs = new ArrayList<Pair<Integer, Duration>>(values.size() / 2);
                try {
                    for (int i = 0; i < values.size(); i += 2) {
                        int numTimesToDoGc = Integer.parseInt(values.get(i));
                        int numSecondsToSleepBetweenGcs = Integer.parseInt(values.get(i + 1));
                        if (numTimesToDoGc <= 0) {
                            throw new OptionsParsingException("Number of times to GC must be positive");
                        }
                        if (numSecondsToSleepBetweenGcs < 0) {
                            throw new OptionsParsingException("Number of seconds to sleep between GC's must be non-negative");
                        }
                        gcSpecs.add(Pair.of(numTimesToDoGc, Duration.ofSeconds(numSecondsToSleepBetweenGcs)));
                    }
                    return new MemoryProfileStableHeapParameters(gcSpecs);
                }
                catch (NumberFormatException | NoSuchElementException nfe) {
                    throw new OptionsParsingException("Expected even number of comma-separated integer values, could not parse integer in list", nfe);
                }
            }

            @Override
            public String getTypeDescription() {
                return "integers, separated by a comma expected in pairs";
            }
        }
    }
}

