/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.profiler;

import com.google.common.base.Preconditions;
import com.google.devtools.build.lib.analysis.BlazeVersionInfo;
import com.google.devtools.build.lib.profiler.Profiler;
import com.google.devtools.build.lib.profiler.ProfilerTask;
import com.google.devtools.build.lib.profiler.ThreadMetadata;
import com.google.devtools.build.lib.profiler.TraceData;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Nullable;

class JsonTraceFileWriter
implements Runnable {
    protected final BlockingQueue<TraceData> queue;
    protected final Thread thread;
    protected IOException savedException;
    private final OutputStream outStream;
    private final long profileStartTimeNanos;
    private final ThreadLocal<Boolean> metadataPosted = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private final boolean slimProfile;
    private final UUID buildID;
    private final String outputBase;
    private static final long SLIM_PROFILE_EVENT_THRESHOLD = 10000L;
    private static final long SLIM_PROFILE_MAXIMAL_PAUSE_NS = Duration.ofMillis(100L).toNanos();
    private static final long SLIM_PROFILE_MAXIMAL_DURATION_NS = Duration.ofMillis(250L).toNanos();
    private static final Profiler.TaskData POISON_PILL = new Profiler.TaskData(0L, null, "poison pill");

    JsonTraceFileWriter(OutputStream outStream, long profileStartTimeNanos, boolean slimProfile, String outputBase, UUID buildID) {
        this.queue = new LinkedBlockingQueue<TraceData>();
        this.thread = new Thread((Runnable)this, "profile-writer-thread");
        this.outStream = outStream;
        this.profileStartTimeNanos = profileStartTimeNanos;
        this.slimProfile = slimProfile;
        this.buildID = buildID;
        this.outputBase = outputBase;
    }

    public void shutdown() throws IOException {
        this.queue.add(POISON_PILL);
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            this.thread.interrupt();
            Thread.currentThread().interrupt();
        }
        if (this.savedException != null) {
            throw this.savedException;
        }
    }

    public void start() {
        this.thread.start();
    }

    public void enqueue(TraceData data) {
        if (!this.metadataPosted.get().booleanValue()) {
            this.metadataPosted.set(Boolean.TRUE);
            this.queue.add(new ThreadMetadata());
        }
        this.queue.add(data);
    }

    private static boolean isCandidateForMerging(Profiler.TaskData data) {
        return data.durationNanos > 0L && data.durationNanos < SLIM_PROFILE_MAXIMAL_DURATION_NS && data.type != ProfilerTask.CRITICAL_PATH_COMPONENT;
    }

    @Override
    public void run() {
        try {
            boolean receivedPoisonPill = false;
            try (JsonWriter writer = new JsonWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(this.outStream, 262144), StandardCharsets.UTF_8));){
                TraceData data;
                Instant finishDate = Instant.now();
                writer.beginObject();
                writer.name("otherData");
                writer.beginObject();
                writer.name("bazel_version").value(BlazeVersionInfo.instance().getReleaseName());
                writer.name("build_id").value(this.buildID.toString());
                writer.name("output_base").value(this.outputBase);
                writer.name("date").value(finishDate.toString());
                writer.name("profile_finish_ts").value(finishDate.getEpochSecond() * 1000L);
                writer.endObject();
                writer.name("traceEvents");
                writer.beginArray();
                ThreadMetadata criticalPathMetadata = ThreadMetadata.createFakeThreadMetadataForCriticalPath();
                criticalPathMetadata.writeTraceData(writer, this.profileStartTimeNanos);
                HashMap<Long, MergedEvent> eventsPerThread = new HashMap<Long, MergedEvent>();
                int eventCount = 0;
                while ((data = this.queue.take()) != POISON_PILL) {
                    Preconditions.checkNotNull(data);
                    if (this.slimProfile && (long)(++eventCount) > 10000L && data instanceof Profiler.TaskData && JsonTraceFileWriter.isCandidateForMerging((Profiler.TaskData)data)) {
                        Profiler.TaskData taskData = (Profiler.TaskData)data;
                        eventsPerThread.putIfAbsent(taskData.threadId, new MergedEvent());
                        Profiler.TaskData mergedTaskData = ((MergedEvent)eventsPerThread.get(taskData.threadId)).maybeMerge(taskData);
                        if (mergedTaskData == null) continue;
                        mergedTaskData.writeTraceData(writer, this.profileStartTimeNanos);
                        continue;
                    }
                    data.writeTraceData(writer, this.profileStartTimeNanos);
                }
                for (MergedEvent value : eventsPerThread.values()) {
                    Profiler.TaskData taskData = value.getAndReset();
                    if (taskData == null) continue;
                    taskData.writeTraceData(writer, this.profileStartTimeNanos);
                }
                receivedPoisonPill = true;
                writer.setIndent("  ");
                writer.endArray();
                writer.endObject();
            }
            catch (IOException e) {
                this.savedException = e;
                if (!receivedPoisonPill) {
                    while (this.queue.take() != POISON_PILL) {
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static final class MergedEvent {
        int count = 0;
        long startTimeNanos;
        long endTimeNanos;
        Profiler.TaskData data;

        private MergedEvent() {
        }

        @Nullable
        Profiler.TaskData maybeMerge(Profiler.TaskData data) {
            long startTimeNanos = data.startTimeNanos;
            long endTimeNanos = startTimeNanos + data.durationNanos;
            if (this.count > 0 && startTimeNanos >= this.startTimeNanos && endTimeNanos <= this.endTimeNanos) {
                return null;
            }
            if (this.count == 0) {
                this.data = data;
                this.startTimeNanos = startTimeNanos;
                this.endTimeNanos = endTimeNanos;
                ++this.count;
                return null;
            }
            if (startTimeNanos <= this.endTimeNanos + SLIM_PROFILE_MAXIMAL_PAUSE_NS) {
                this.endTimeNanos = endTimeNanos;
                ++this.count;
                return null;
            }
            Profiler.TaskData ret = this.getAndReset();
            this.startTimeNanos = startTimeNanos;
            this.endTimeNanos = endTimeNanos;
            this.data = data;
            this.count = 1;
            return ret;
        }

        Profiler.TaskData getAndReset() {
            Profiler.TaskData ret = this.data == null || this.count <= 1 ? this.data : new Profiler.TaskData(this.data.threadId, this.startTimeNanos, this.endTimeNanos - this.startTimeNanos, "merged " + this.count + " events");
            this.count = 0;
            this.data = null;
            return ret;
        }
    }
}

