/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.profiler;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.build.lib.profiler.ProfilerTask;
import com.google.devtools.build.lib.profiler.TraceData;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class CounterSeriesTraceData
implements TraceData {
    private final Map<ProfilerTask, double[]> counterSeriesMap;
    private final Duration profileStart;
    private final Duration bucketDuration;
    private final int len;
    private String displayName;
    @Nullable
    private String colorName;
    private static final ImmutableMap<ProfilerTask, String> COUNTER_TASK_TO_COLOR = ImmutableMap.ofEntries(Map.entry(ProfilerTask.LOCAL_CPU_USAGE, "good"), Map.entry(ProfilerTask.SYSTEM_CPU_USAGE, "rail_load"), Map.entry(ProfilerTask.LOCAL_MEMORY_USAGE, "olive"), Map.entry(ProfilerTask.SYSTEM_MEMORY_USAGE, "bad"), Map.entry(ProfilerTask.SYSTEM_NETWORK_UP_USAGE, "rail_response"), Map.entry(ProfilerTask.SYSTEM_NETWORK_DOWN_USAGE, "rail_response"), Map.entry(ProfilerTask.WORKERS_MEMORY_USAGE, "rail_animation"), Map.entry(ProfilerTask.SYSTEM_LOAD_AVERAGE, "generic_work"), Map.entry(ProfilerTask.MEMORY_USAGE_ESTIMATION, "rail_idle"), Map.entry(ProfilerTask.CPU_USAGE_ESTIMATION, "cq_build_attempt_passed"), Map.entry(ProfilerTask.PRESSURE_STALL_IO, "rail_idle"), Map.entry(ProfilerTask.PRESSURE_STALL_MEMORY, "rail_animation"));
    private static final ImmutableMap<ProfilerTask, String> COUNTER_TASK_TO_SERIES_NAME = ImmutableMap.ofEntries(Map.entry(ProfilerTask.ACTION_COUNTS, "action"), Map.entry(ProfilerTask.ACTION_CACHE_COUNTS, "local action cache"), Map.entry(ProfilerTask.LOCAL_CPU_USAGE, "cpu"), Map.entry(ProfilerTask.SYSTEM_CPU_USAGE, "system cpu"), Map.entry(ProfilerTask.LOCAL_MEMORY_USAGE, "memory"), Map.entry(ProfilerTask.SYSTEM_MEMORY_USAGE, "system memory"), Map.entry(ProfilerTask.SYSTEM_NETWORK_UP_USAGE, "system network up (Mbps)"), Map.entry(ProfilerTask.SYSTEM_NETWORK_DOWN_USAGE, "system network down (Mbps)"), Map.entry(ProfilerTask.WORKERS_MEMORY_USAGE, "workers memory"), Map.entry(ProfilerTask.SYSTEM_LOAD_AVERAGE, "load"), Map.entry(ProfilerTask.MEMORY_USAGE_ESTIMATION, "estimated memory"), Map.entry(ProfilerTask.CPU_USAGE_ESTIMATION, "estimated cpu"), Map.entry(ProfilerTask.PRESSURE_STALL_IO, "i/o pressure"), Map.entry(ProfilerTask.PRESSURE_STALL_MEMORY, "memory pressure"));

    CounterSeriesTraceData(Map<ProfilerTask, double[]> counterSeriesMap, Duration profileStart, Duration bucketDuration) {
        Integer len = null;
        for (ProfilerTask profilerTask : counterSeriesMap.keySet()) {
            Preconditions.checkState(COUNTER_TASK_TO_SERIES_NAME.containsKey((Object)profilerTask));
            if (len == null) {
                len = counterSeriesMap.get((Object)profilerTask).length;
                this.displayName = profilerTask.description;
                this.colorName = COUNTER_TASK_TO_COLOR.get((Object)profilerTask);
                continue;
            }
            Preconditions.checkState(len.equals(counterSeriesMap.get((Object)profilerTask).length));
        }
        this.len = len;
        this.counterSeriesMap = counterSeriesMap;
        this.profileStart = profileStart;
        this.bucketDuration = bucketDuration;
    }

    @Override
    public void writeTraceData(JsonWriter jsonWriter, long profileStartTimeNanos) throws IOException {
        for (int i = 0; i < this.len; ++i) {
            long timeNanos = this.profileStart.plus(this.bucketDuration.multipliedBy(i)).toNanos();
            jsonWriter.setIndent("  ");
            jsonWriter.beginObject();
            jsonWriter.setIndent("");
            jsonWriter.name("name").value(this.displayName);
            jsonWriter.name("pid").value(1L);
            if (this.colorName != null) {
                jsonWriter.name("cname").value(this.colorName);
            }
            jsonWriter.name("ph").value("C");
            jsonWriter.name("ts").value(TimeUnit.NANOSECONDS.toMicros(timeNanos - profileStartTimeNanos));
            jsonWriter.name("args");
            jsonWriter.beginObject();
            for (ProfilerTask profilerTask : this.counterSeriesMap.keySet()) {
                double value = this.counterSeriesMap.get((Object)profilerTask)[i];
                if (!(Math.abs(value) > 1.0E-5)) continue;
                jsonWriter.name(COUNTER_TASK_TO_SERIES_NAME.get((Object)profilerTask)).value(value);
            }
            jsonWriter.endObject();
            jsonWriter.endObject();
        }
    }
}

