/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.profiler;

import com.google.common.base.Preconditions;
import com.google.devtools.build.lib.clock.BlazeClock;
import com.google.devtools.build.lib.clock.Clock;
import com.google.devtools.build.lib.profiler.Profiler;
import com.google.devtools.build.lib.profiler.ProfilerTask;
import com.google.devtools.build.lib.profiler.SilentCloseable;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class AutoProfiler
implements SilentCloseable {
    private static final AtomicReference<Clock> CLOCK_REF = new AtomicReference<Object>(null);
    private final ElapsedTimeReceiver elapsedTimeReceiver;
    private final long startTimeNanos;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    private AutoProfiler(ElapsedTimeReceiver elapsedTimeReceiver, long startTimeNanos) {
        this.elapsedTimeReceiver = elapsedTimeReceiver;
        this.startTimeNanos = startTimeNanos;
    }

    public static void setClock(Clock clock) {
        CLOCK_REF.set(clock);
    }

    private static long nanoTime() {
        Clock clock = CLOCK_REF.get();
        return clock != null ? clock.nanoTime() : BlazeClock.instance().nanoTime();
    }

    public static AutoProfiler profiled(String description, ProfilerTask profilerTaskType) {
        return AutoProfiler.create(new ProfilingElapsedTimeReceiver(description, profilerTaskType));
    }

    public static AutoProfiler create(ElapsedTimeReceiver elapsedTimeReceiver) {
        return new AutoProfiler(elapsedTimeReceiver, AutoProfiler.nanoTime());
    }

    public void complete() {
        this.close();
    }

    public long completeAndGetElapsedTimeNanos() {
        long elapsedTimeNanos = AutoProfiler.nanoTime() - this.startTimeNanos;
        Preconditions.checkState(this.closed.compareAndSet(false, true));
        this.elapsedTimeReceiver.accept(elapsedTimeNanos);
        return elapsedTimeNanos;
    }

    @Override
    public void close() {
        long elapsedTimeNanos = AutoProfiler.nanoTime() - this.startTimeNanos;
        Preconditions.checkState(this.closed.compareAndSet(false, true));
        this.elapsedTimeReceiver.accept(elapsedTimeNanos);
    }

    static class ProfilingElapsedTimeReceiver
    implements ElapsedTimeReceiver {
        private final long startTimeNanos = Profiler.nanoTimeMaybe();
        private final String description;
        private final ProfilerTask profilerTaskType;

        ProfilingElapsedTimeReceiver(String description, ProfilerTask profilerTaskType) {
            this.description = description;
            this.profilerTaskType = profilerTaskType;
        }

        @Override
        public void accept(long elapsedTimeNanos) {
            if (elapsedTimeNanos > 0L) {
                Profiler.instance().logSimpleTaskDuration(this.startTimeNanos, Duration.ofNanos(elapsedTimeNanos), this.profilerTaskType, this.description);
            }
        }
    }

    public static interface ElapsedTimeReceiver {
        public void accept(long var1);
    }
}

