/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.build.lib.cmdline.BazelModuleContext;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.cmdline.LabelSyntaxException;
import com.google.devtools.build.lib.cmdline.LabelValidator;
import com.google.devtools.build.lib.cmdline.RepositoryMapping;
import com.google.devtools.build.lib.cmdline.RepositoryName;
import com.google.devtools.build.lib.cmdline.TargetParsingException;
import com.google.devtools.build.lib.cmdline.TargetPattern;
import com.google.devtools.build.lib.packages.Package;
import com.google.devtools.build.lib.packages.PackageFactory;
import com.google.devtools.build.lib.packages.RuleClass;
import com.google.devtools.build.lib.packages.RuleFactory;
import com.google.devtools.build.lib.packages.WorkspaceFactoryHelper;
import com.google.devtools.build.lib.starlarkbuildapi.WorkspaceGlobalsApi;
import com.google.devtools.build.lib.vfs.PathFragment;
import java.util.List;
import javax.annotation.Nullable;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Module;
import net.starlark.java.eval.Sequence;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkThread;

public class WorkspaceGlobals
implements WorkspaceGlobalsApi {
    private final boolean allowOverride;
    private final ImmutableMap<String, RuleClass> ruleClassMap;

    public WorkspaceGlobals(boolean allowOverride, ImmutableMap<String, RuleClass> ruleClassMap) {
        this.allowOverride = allowOverride;
        this.ruleClassMap = ruleClassMap;
    }

    @Override
    public void workspace(String name, StarlarkThread thread) throws EvalException, InterruptedException {
        if (!this.allowOverride) {
            throw Starlark.errorf("workspace() function should be used only at the top of the WORKSPACE file", new Object[0]);
        }
        RepositoryName.validateUserProvidedRepoName(name);
        String errorMessage = LabelValidator.validateTargetName(name);
        if (errorMessage != null) {
            throw Starlark.errorf("%s", errorMessage);
        }
        PackageFactory.getContext((StarlarkThread)thread).pkgBuilder.setWorkspaceName(name);
        Package.Builder builder = PackageFactory.getContext((StarlarkThread)thread).pkgBuilder;
        RuleClass localRepositoryRuleClass = this.ruleClassMap.get("local_repository");
        RuleClass bindRuleClass = this.ruleClassMap.get("bind");
        ImmutableMap<String, Object> kwargs = ImmutableMap.of("name", name, "path", ".");
        try {
            WorkspaceFactoryHelper.createAndAddRepositoryRule(builder, localRepositoryRuleClass, bindRuleClass, kwargs, thread.getCallStack());
        }
        catch (LabelSyntaxException | Package.NameConflictException | RuleFactory.InvalidRuleException e) {
            throw Starlark.errorf("%s", e.getMessage());
        }
        builder.addRepositoryMappingEntry(RepositoryName.MAIN, name, RepositoryName.MAIN);
    }

    private static RepositoryName getRepositoryName(@Nullable Label label) {
        if (label == null) {
            return RepositoryName.MAIN;
        }
        return label.getRepository();
    }

    private static ImmutableList<TargetPattern> parsePatterns(List<String> patterns, Package.Builder builder, StarlarkThread thread) throws EvalException {
        BazelModuleContext bzlModule = BazelModuleContext.of(Module.ofInnermostEnclosingStarlarkFunction(thread));
        RepositoryName myName = WorkspaceGlobals.getRepositoryName(bzlModule != null ? bzlModule.label() : null);
        RepositoryMapping renaming = builder.getRepositoryMappingFor(myName);
        TargetPattern.Parser parser = new TargetPattern.Parser(PathFragment.EMPTY_FRAGMENT, myName, renaming);
        ImmutableList.Builder parsedPatterns = ImmutableList.builder();
        for (String pattern : patterns) {
            try {
                parsedPatterns.add(parser.parse(pattern));
            }
            catch (TargetParsingException e) {
                throw Starlark.errorf("error parsing target pattern \"%s\": %s", pattern, e.getMessage());
            }
        }
        return parsedPatterns.build();
    }

    @Override
    public void registerExecutionPlatforms(Sequence<?> platformLabels, StarlarkThread thread) throws EvalException {
        Package.Builder builder = PackageFactory.getContext((StarlarkThread)thread).pkgBuilder;
        Sequence<String> patterns = Sequence.cast(platformLabels, String.class, "platform_labels");
        builder.addRegisteredExecutionPlatforms(WorkspaceGlobals.parsePatterns(patterns, builder, thread));
    }

    @Override
    public void registerToolchains(Sequence<?> toolchainLabels, StarlarkThread thread) throws EvalException {
        Package.Builder builder = PackageFactory.getContext((StarlarkThread)thread).pkgBuilder;
        Sequence<String> patterns = Sequence.cast(toolchainLabels, String.class, "toolchain_labels");
        builder.addRegisteredToolchains(WorkspaceGlobals.parsePatterns(patterns, builder, thread));
    }

    @Override
    public void bind(String name, Object actual, StarlarkThread thread) throws EvalException, InterruptedException {
        Label nameLabel;
        try {
            nameLabel = Label.parseCanonical("//external:" + name);
        }
        catch (LabelSyntaxException e) {
            throw Starlark.errorf("%s", e.getMessage());
        }
        try {
            Package.Builder builder = PackageFactory.getContext((StarlarkThread)thread).pkgBuilder;
            RuleClass ruleClass = this.ruleClassMap.get("bind");
            WorkspaceFactoryHelper.addBindRule(builder, ruleClass, nameLabel, actual == Starlark.NONE ? null : Label.parseCanonical((String)actual), thread.getCallStack());
        }
        catch (LabelSyntaxException | Package.NameConflictException | RuleFactory.InvalidRuleException e) {
            throw Starlark.errorf("%s", e.getMessage());
        }
    }
}

