/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.build.lib.cmdline.RepositoryName;
import com.google.devtools.build.lib.packages.Package;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.AutoCodec;
import com.google.devtools.build.lib.vfs.RootedPath;
import com.google.devtools.build.skyframe.SkyFunctionName;
import com.google.devtools.build.skyframe.SkyKey;
import com.google.devtools.build.skyframe.SkyValue;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.starlark.java.eval.Module;

public class WorkspaceFileValue
implements SkyValue {
    public static final SkyFunctionName WORKSPACE_FILE = SkyFunctionName.createHermetic("WORKSPACE_FILE");
    private final Package pkg;
    private final int idx;
    private final RootedPath path;
    private final boolean hasNext;
    private final ImmutableMap<String, Object> bindings;
    private final ImmutableMap<String, Module> loadedModules;
    private final ImmutableMap<String, Integer> loadToChunkMap;
    private final ImmutableMap<RepositoryName, ImmutableMap<String, RepositoryName>> repositoryMapping;

    public WorkspaceFileValue(Package pkg, Map<String, Module> loadedModules, Map<String, Integer> loadToChunkMap, Map<String, Object> bindings, RootedPath path, int idx, boolean hasNext) {
        this.pkg = Preconditions.checkNotNull(pkg);
        this.idx = idx;
        this.path = path;
        this.hasNext = hasNext;
        this.bindings = ImmutableMap.copyOf(bindings);
        this.loadedModules = ImmutableMap.copyOf(loadedModules);
        this.loadToChunkMap = ImmutableMap.copyOf(loadToChunkMap);
        this.repositoryMapping = pkg.getExternalPackageRepositoryMappings();
    }

    public Package getPackage() {
        return this.pkg;
    }

    public String toString() {
        return "<WorkspaceFileValue path=" + this.path + " idx=" + this.idx + ">";
    }

    public static WorkspaceFileKey key(RootedPath path, int idx) {
        return WorkspaceFileKey.create(path, idx);
    }

    public static WorkspaceFileKey key(RootedPath path) {
        return WorkspaceFileValue.key(path, 0);
    }

    @Nullable
    public SkyKey next() {
        if (this.hasNext) {
            return WorkspaceFileValue.key(this.path, this.idx + 1);
        }
        return null;
    }

    public int getIndex() {
        return this.idx;
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public RootedPath getPath() {
        return this.path;
    }

    public ImmutableMap<String, Object> getBindings() {
        return this.bindings;
    }

    public ImmutableMap<String, Module> getLoadedModules() {
        return this.loadedModules;
    }

    public ImmutableMap<String, Integer> getLoadToChunkMap() {
        return this.loadToChunkMap;
    }

    public ImmutableMap<RepositoryName, ImmutableMap<String, RepositoryName>> getRepositoryMapping() {
        return this.repositoryMapping;
    }

    @AutoCodec
    public static class WorkspaceFileKey
    implements SkyKey {
        private static final SkyKey.SkyKeyInterner<WorkspaceFileKey> interner = SkyKey.newInterner();
        private final RootedPath path;
        private final int idx;

        private WorkspaceFileKey(RootedPath path, int idx) {
            this.path = path;
            this.idx = idx;
        }

        @AutoCodec.VisibleForSerialization
        @AutoCodec.Instantiator
        static WorkspaceFileKey create(RootedPath path, int idx) {
            return interner.intern(new WorkspaceFileKey(path, idx));
        }

        public RootedPath getPath() {
            return this.path;
        }

        public int getIndex() {
            return this.idx;
        }

        @Override
        public SkyFunctionName functionName() {
            return WORKSPACE_FILE;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof WorkspaceFileKey)) {
                return false;
            }
            WorkspaceFileKey other = (WorkspaceFileKey)obj;
            return Objects.equals(this.path, other.path) && this.idx == other.idx;
        }

        public int hashCode() {
            return Objects.hash(this.path.hashCode(), this.idx);
        }

        public String toString() {
            return this.path + ", " + this.idx;
        }

        public SkyKey.SkyKeyInterner<WorkspaceFileKey> getSkyKeyInterner() {
            return interner;
        }
    }
}

