/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.cmdline.LabelSyntaxException;
import com.google.devtools.build.lib.cmdline.RepositoryName;
import com.google.devtools.build.lib.cmdline.TargetParsingException;
import com.google.devtools.build.lib.cmdline.TargetPattern;
import com.google.devtools.build.lib.events.StoredEventHandler;
import com.google.devtools.build.lib.packages.Package;
import com.google.devtools.build.lib.packages.Rule;
import com.google.devtools.build.lib.packages.RuleClass;
import com.google.devtools.build.lib.packages.RuleFactory;
import com.google.devtools.build.lib.packages.Target;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.starlark.java.eval.Dict;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.StarlarkThread;

public final class WorkspaceFactoryHelper {
    @CanIgnoreReturnValue
    public static Rule createAndAddRepositoryRule(Package.Builder pkg, RuleClass ruleClass, RuleClass bindRuleClass, Map<String, Object> kwargs, ImmutableList<StarlarkThread.CallStackEntry> callstack) throws RuleFactory.InvalidRuleException, Package.NameConflictException, LabelSyntaxException, InterruptedException {
        StoredEventHandler eventHandler = new StoredEventHandler();
        RuleFactory.BuildLangTypedAttributeValuesMap attributeValues = new RuleFactory.BuildLangTypedAttributeValuesMap(kwargs);
        Rule rule = RuleFactory.createRule(pkg, ruleClass, attributeValues, eventHandler, callstack);
        pkg.addEvents(eventHandler.getEvents());
        pkg.addPosts(eventHandler.getPosts());
        WorkspaceFactoryHelper.overwriteRule(pkg, rule);
        for (Map.Entry<String, Label> entry : ruleClass.getExternalBindingsFunction().apply(rule).entrySet()) {
            Label nameLabel = Label.parseCanonical("//external:" + entry.getKey());
            WorkspaceFactoryHelper.addBindRule(pkg, bindRuleClass, nameLabel, entry.getValue(), callstack);
        }
        ImmutableList.Builder toolchains = new ImmutableList.Builder();
        for (String pattern : ruleClass.getToolchainsToRegisterFunction().apply(rule)) {
            try {
                toolchains.add(TargetPattern.defaultParser().parse(pattern));
            }
            catch (TargetParsingException e) {
                throw new LabelSyntaxException(e.getMessage());
            }
        }
        pkg.addRegisteredToolchains((List<TargetPattern>)((Object)toolchains.build()));
        return rule;
    }

    public static Map<String, Object> getFinalKwargs(Map<String, Object> kwargs) {
        return kwargs.entrySet().stream().filter(x -> !((String)x.getKey()).equals("repo_mapping")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static void addMainRepoEntry(Package.Builder builder, String externalRepoName) throws LabelSyntaxException {
        if (!Strings.isNullOrEmpty(builder.getPackageWorkspaceName())) {
            builder.addRepositoryMappingEntry(RepositoryName.create(externalRepoName), builder.getPackageWorkspaceName(), RepositoryName.MAIN);
        }
    }

    public static void addRepoMappings(Package.Builder builder, Map<String, Object> kwargs, String externalRepoName) throws EvalException, LabelSyntaxException {
        Object repoMapping = kwargs.get("repo_mapping");
        if (repoMapping != null) {
            for (Map.Entry<String, String> e : Dict.cast(repoMapping, String.class, String.class, "repo_mapping").entrySet()) {
                if (!e.getKey().startsWith("@")) {
                    throw new LabelSyntaxException("invalid repository name '" + e.getKey() + "': repo names used in the repo_mapping attribute must start with '@'");
                }
                if (!e.getValue().startsWith("@")) {
                    throw new LabelSyntaxException("invalid repository name '" + e.getValue() + "': repo names used in the repo_mapping attribute must start with '@'");
                }
                RepositoryName.validateUserProvidedRepoName(e.getKey().substring(1));
                builder.addRepositoryMappingEntry(RepositoryName.create(externalRepoName), e.getKey().substring(1), RepositoryName.create(e.getValue().substring(1)));
            }
        }
    }

    static void addBindRule(Package.Builder pkg, RuleClass bindRuleClass, Label virtual, Label actual, ImmutableList<StarlarkThread.CallStackEntry> callstack) throws RuleFactory.InvalidRuleException, Package.NameConflictException, InterruptedException {
        HashMap<String, Object> attributes = Maps.newHashMap();
        attributes.put("name", virtual.getName());
        if (actual != null) {
            attributes.put("actual", actual);
        }
        StoredEventHandler handler = new StoredEventHandler();
        RuleFactory.BuildLangTypedAttributeValuesMap attributeValues = new RuleFactory.BuildLangTypedAttributeValuesMap(attributes);
        Rule rule = RuleFactory.createRule(pkg, bindRuleClass, attributeValues, handler, callstack);
        WorkspaceFactoryHelper.overwriteRule(pkg, rule);
    }

    private static void overwriteRule(Package.Builder pkg, Rule rule) throws Package.NameConflictException {
        Preconditions.checkArgument(rule.getOutputFiles().isEmpty());
        Target old = pkg.getTarget(rule.getName());
        if (old != null) {
            if (old instanceof Rule) {
                Verify.verify(((Rule)old).getOutputFiles().isEmpty());
            }
            pkg.replaceTarget(rule);
        } else {
            pkg.addRule(rule);
        }
    }

    private WorkspaceFactoryHelper() {
    }
}

