/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.packages;

import com.google.common.collect.ImmutableMap;
import com.google.devtools.build.lib.cmdline.LabelSyntaxException;
import com.google.devtools.build.lib.cmdline.RepositoryName;
import com.google.devtools.build.lib.events.Event;
import com.google.devtools.build.lib.events.EventHandler;
import com.google.devtools.build.lib.events.NullEventHandler;
import com.google.devtools.build.lib.events.StoredEventHandler;
import com.google.devtools.build.lib.packages.BazelStarlarkContext;
import com.google.devtools.build.lib.packages.Package;
import com.google.devtools.build.lib.packages.PackageFactory;
import com.google.devtools.build.lib.packages.Rule;
import com.google.devtools.build.lib.packages.RuleClass;
import com.google.devtools.build.lib.packages.RuleClassProvider;
import com.google.devtools.build.lib.packages.RuleFactory;
import com.google.devtools.build.lib.packages.SelectorList;
import com.google.devtools.build.lib.packages.StarlarkLibrary;
import com.google.devtools.build.lib.packages.StarlarkNativeModule;
import com.google.devtools.build.lib.packages.SymbolGenerator;
import com.google.devtools.build.lib.packages.WorkspaceFactoryHelper;
import com.google.devtools.build.lib.packages.WorkspaceFileValue;
import com.google.devtools.build.lib.packages.WorkspaceGlobals;
import com.google.devtools.build.lib.server.FailureDetails;
import com.google.devtools.build.lib.vfs.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.starlark.java.eval.Dict;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Module;
import net.starlark.java.eval.Mutability;
import net.starlark.java.eval.Printer;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkCallable;
import net.starlark.java.eval.StarlarkSemantics;
import net.starlark.java.eval.StarlarkThread;
import net.starlark.java.eval.Tuple;
import net.starlark.java.syntax.Location;
import net.starlark.java.syntax.Program;
import net.starlark.java.syntax.StarlarkFile;
import net.starlark.java.syntax.SyntaxError;

public class WorkspaceFactory {
    private final Package.Builder builder;
    private final Path installDir;
    private final Path workspaceDir;
    private final Path defaultSystemJavabaseDir;
    private final Mutability mutability;
    private final StarlarkSemantics starlarkSemantics;
    private final ImmutableMap<String, Object> workspaceFunctions;
    private final Map<String, Module> loadedModules = new HashMap<String, Module>();
    private final Map<String, Object> bindings = new HashMap<String, Object>();

    public WorkspaceFactory(Package.Builder builder, RuleClassProvider ruleClassProvider, Mutability mutability, boolean allowOverride, @Nullable Path installDir, @Nullable Path workspaceDir, @Nullable Path defaultSystemJavabaseDir, StarlarkSemantics starlarkSemantics) {
        this.builder = builder;
        this.mutability = mutability;
        this.installDir = installDir;
        this.workspaceDir = workspaceDir;
        this.defaultSystemJavabaseDir = defaultSystemJavabaseDir;
        this.starlarkSemantics = starlarkSemantics;
        this.workspaceFunctions = WorkspaceFactory.createWorkspaceFunctions(allowOverride, ruleClassProvider.getRuleClassMap(), new WorkspaceGlobals(allowOverride, ruleClassProvider.getRuleClassMap()), starlarkSemantics);
    }

    public void execute(StarlarkFile file, Map<String, Module> additionalLoadedModules, WorkspaceFileValue.WorkspaceFileKey workspaceFileKey) throws InterruptedException {
        this.loadedModules.putAll(additionalLoadedModules);
        HashMap<String, Object> predeclared = new HashMap<String, Object>();
        predeclared.putAll(this.getDefaultEnvironment());
        predeclared.putAll(this.bindings);
        Module module = Module.withPredeclared(this.starlarkSemantics, predeclared);
        StoredEventHandler localReporter = new StoredEventHandler();
        try {
            Program prog = Program.compileFile(file, module);
            StarlarkThread thread = new StarlarkThread(this.mutability, this.starlarkSemantics);
            thread.setLoader(this.loadedModules::get);
            thread.setPrintHandler(Event.makeDebugPrintHandler(localReporter));
            thread.setThreadLocal(PackageFactory.PackageContext.class, new PackageFactory.PackageContext(this.builder, null, localReporter));
            new BazelStarlarkContext(BazelStarlarkContext.Phase.WORKSPACE, null, null, new SymbolGenerator<WorkspaceFileValue.WorkspaceFileKey>(workspaceFileKey), null, null).storeInThread(thread);
            ArrayList<String> globs = new ArrayList<String>();
            if (PackageFactory.checkBuildSyntax(file, globs, globs, globs, new HashMap<Location, String>(), error -> localReporter.handle(Package.error(error.location(), error.message(), FailureDetails.PackageLoading.Code.SYNTAX_ERROR)))) {
                try {
                    Starlark.execFileProgram(prog, module, thread);
                }
                catch (EvalException ex) {
                    localReporter.handle(Package.error(null, ex.getMessageWithStack(), FailureDetails.PackageLoading.Code.STARLARK_EVAL_ERROR));
                }
            }
            this.bindings.putAll(module.getGlobals());
        }
        catch (SyntaxError.Exception ex) {
            Event.replayEventsOn((EventHandler)localReporter, ex.errors());
            this.builder.setFailureDetailOverride(FailureDetails.FailureDetail.newBuilder().setMessage(ex.getMessage()).setPackageLoading(FailureDetails.PackageLoading.newBuilder().setCode(FailureDetails.PackageLoading.Code.SYNTAX_ERROR)).build());
        }
        this.builder.addPosts(localReporter.getPosts());
        this.builder.addEvents(localReporter.getEvents());
        if (localReporter.hasErrors()) {
            this.builder.setContainsErrors();
        }
    }

    public void setParent(Package aPackage, Map<String, Module> loadedModules, Map<String, Object> bindings) throws Package.NameConflictException, InterruptedException {
        this.bindings.putAll(bindings);
        this.loadedModules.putAll(loadedModules);
        this.builder.setWorkspaceName(aPackage.getWorkspaceName());
        if (aPackage.containsErrors()) {
            this.builder.setContainsErrors();
        }
        if (aPackage.getFailureDetail() != null) {
            this.builder.setFailureDetailOverride(aPackage.getFailureDetail());
        }
        this.builder.addRegisteredExecutionPlatforms(aPackage.getRegisteredExecutionPlatforms());
        this.builder.addRegisteredToolchains(aPackage.getRegisteredToolchains());
        this.builder.addRepositoryMappings(aPackage);
        for (Rule rule : aPackage.getTargets(Rule.class)) {
            try {
                Rule newRule = this.builder.createRule(rule.getLabel(), rule.getRuleClassObject(), rule.getLocation(), rule.getInteriorCallStack());
                newRule.copyAttributesFrom(rule);
                newRule.populateOutputFiles(NullEventHandler.INSTANCE, this.builder);
                if (rule.containsErrors()) {
                    newRule.setContainsErrors();
                }
                this.builder.addRule(newRule);
            }
            catch (LabelSyntaxException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static StarlarkCallable newRuleFunction(final ImmutableMap<String, RuleClass> ruleClassMap, final String ruleClassName, final boolean allowOverride) {
        return new StarlarkCallable(){

            @Override
            public String getName() {
                return ruleClassName;
            }

            public String toString() {
                return this.getName() + "(...)";
            }

            @Override
            public boolean isImmutable() {
                return true;
            }

            @Override
            public void repr(Printer printer) {
                printer.append("<built-in function " + this.getName() + ">");
            }

            @Override
            public Object call(StarlarkThread thread, Tuple args, Dict<String, Object> kwargs) throws EvalException, InterruptedException {
                if (!args.isEmpty()) {
                    throw new EvalException("unexpected positional arguments");
                }
                try {
                    Package.Builder builder = PackageFactory.getContext((StarlarkThread)thread).pkgBuilder;
                    String externalRepoName = (String)kwargs.get("name");
                    if (!allowOverride && externalRepoName != null && builder.getTarget(externalRepoName) != null) {
                        throw Starlark.errorf("Cannot redefine repository after any load statement in the WORKSPACE file (for repository '%s')", externalRepoName);
                    }
                    WorkspaceFactoryHelper.addMainRepoEntry(builder, externalRepoName);
                    WorkspaceFactoryHelper.addRepoMappings(builder, kwargs, externalRepoName);
                    RuleClass ruleClass = (RuleClass)ruleClassMap.get(ruleClassName);
                    RuleClass bindRuleClass = (RuleClass)ruleClassMap.get("bind");
                    Rule rule = WorkspaceFactoryHelper.createAndAddRepositoryRule(builder, ruleClass, bindRuleClass, WorkspaceFactoryHelper.getFinalKwargs(kwargs), thread.getCallStack());
                    RepositoryName.validateUserProvidedRepoName(rule.getName());
                }
                catch (LabelSyntaxException | Package.NameConflictException | RuleFactory.InvalidRuleException e) {
                    throw new EvalException(e);
                }
                return Starlark.NONE;
            }
        };
    }

    private static ImmutableMap<String, Object> createWorkspaceFunctions(boolean allowOverride, ImmutableMap<String, RuleClass> ruleClassMap, WorkspaceGlobals workspaceGlobals, StarlarkSemantics starlarkSemantics) {
        ImmutableMap.Builder<String, Object> env = ImmutableMap.builder();
        Starlark.addMethods(env, workspaceGlobals, starlarkSemantics);
        for (String ruleClass : ruleClassMap.keySet()) {
            if (ruleClass.equals("bind")) continue;
            StarlarkCallable ruleFunction = WorkspaceFactory.newRuleFunction(ruleClassMap, ruleClass, allowOverride);
            env.put(ruleClass, ruleFunction);
        }
        return env.buildOrThrow();
    }

    private ImmutableMap<String, Object> getDefaultEnvironment() {
        ImmutableMap.Builder<String, Object> env = ImmutableMap.builder();
        env.putAll(StarlarkLibrary.COMMON);
        Starlark.addMethods(env, SelectorList.SelectLibrary.INSTANCE);
        env.putAll(this.workspaceFunctions);
        if (this.installDir != null) {
            env.put("__embedded_dir__", this.installDir.getPathString());
        }
        if (this.workspaceDir != null) {
            env.put("__workspace_dir__", this.workspaceDir.getPathString());
        }
        env.put("DEFAULT_SYSTEM_JAVABASE", this.getDefaultSystemJavabase());
        return env.buildOrThrow();
    }

    private String getDefaultSystemJavabase() {
        return this.defaultSystemJavabaseDir != null ? this.defaultSystemJavabaseDir.toString() : this.installDir.getRelative("embedded_tools/tools/jdk/nosystemjdk").getPathString();
    }

    static ImmutableMap<String, Object> createNativeModuleBindings(RuleClassProvider ruleClassProvider) {
        WorkspaceGlobals workspaceGlobals = new WorkspaceGlobals(false, ruleClassProvider.getRuleClassMap());
        ImmutableMap<String, Object> workspaceFunctions = WorkspaceFactory.createWorkspaceFunctions(false, ruleClassProvider.getRuleClassMap(), workspaceGlobals, StarlarkSemantics.DEFAULT);
        ImmutableMap.Builder<String, Object> bindings = new ImmutableMap.Builder<String, Object>();
        Starlark.addMethods(bindings, new StarlarkNativeModule());
        for (Map.Entry entry : workspaceFunctions.entrySet()) {
            String name = (String)entry.getKey();
            if (name.startsWith("$") || name.equals("workspace")) continue;
            bindings.put(entry);
        }
        bindings.put("bazel_version", ruleClassProvider.getVersion());
        return bindings.buildOrThrow();
    }

    public Map<String, Module> getLoadedModules() {
        return this.loadedModules;
    }

    public Map<String, Object> getVariableBindings() {
        return ImmutableMap.copyOf(this.bindings);
    }
}

